<?php

namespace eContract\EnumType;

/**
 * This class stands for ContractTemplateTypes EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractTemplateTypes
 * @subpackage Enumerations
 */
class ContractTemplateTypes
{
    /**
     * Constant for value 'Undefined'
     * @return string 'Undefined'
     */
    const VALUE_UNDEFINED = 'Undefined';
    /**
     * Constant for value 'Nest'
     * @return string 'Nest'
     */
    const VALUE_NEST = 'Nest';
    /**
     * Constant for value 'TMobile'
     * @return string 'TMobile'
     */
    const VALUE_TMOBILE = 'TMobile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_NEST
     * @uses self::VALUE_TMOBILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_NEST,
            self::VALUE_TMOBILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
