<?php

namespace eContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocuSignTemplateBaseObject StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DocuSignTemplateBaseObject
 * @subpackage Structs
 */
class DocuSignTemplateBaseObject extends AbstractStructBase
{
    /**
     * The DealerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerNumber;
    /**
     * The DocSignatures
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \eContract\ArrayType\ArrayOfDocumentSignatures
     */
    public $DocSignatures;
    /**
     * The EmailBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBody;
    /**
     * The EmailReplyToOverrideEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailReplyToOverrideEmail;
    /**
     * The EmailReplyToOverrideName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailReplyToOverrideName;
    /**
     * The EmailSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSubject;
    /**
     * The EnvelopeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvelopeID;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The TemplateKeyValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TemplateKeyValue;
    /**
     * The TemplateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TemplateType;
    /**
     * Constructor method for DocuSignTemplateBaseObject
     * @uses DocuSignTemplateBaseObject::setDealerNumber()
     * @uses DocuSignTemplateBaseObject::setDocSignatures()
     * @uses DocuSignTemplateBaseObject::setEmailBody()
     * @uses DocuSignTemplateBaseObject::setEmailReplyToOverrideEmail()
     * @uses DocuSignTemplateBaseObject::setEmailReplyToOverrideName()
     * @uses DocuSignTemplateBaseObject::setEmailSubject()
     * @uses DocuSignTemplateBaseObject::setEnvelopeID()
     * @uses DocuSignTemplateBaseObject::setLanguage()
     * @uses DocuSignTemplateBaseObject::setTemplateKeyValue()
     * @uses DocuSignTemplateBaseObject::setTemplateType()
     * @param string $dealerNumber
     * @param \eContract\ArrayType\ArrayOfDocumentSignatures $docSignatures
     * @param string $emailBody
     * @param string $emailReplyToOverrideEmail
     * @param string $emailReplyToOverrideName
     * @param string $emailSubject
     * @param string $envelopeID
     * @param string $language
     * @param string $templateKeyValue
     * @param string $templateType
     */
    public function __construct($dealerNumber = null, \eContract\ArrayType\ArrayOfDocumentSignatures $docSignatures = null, $emailBody = null, $emailReplyToOverrideEmail = null, $emailReplyToOverrideName = null, $emailSubject = null, $envelopeID = null, $language = null, $templateKeyValue = null, $templateType = null)
    {
        $this
            ->setDealerNumber($dealerNumber)
            ->setDocSignatures($docSignatures)
            ->setEmailBody($emailBody)
            ->setEmailReplyToOverrideEmail($emailReplyToOverrideEmail)
            ->setEmailReplyToOverrideName($emailReplyToOverrideName)
            ->setEmailSubject($emailSubject)
            ->setEnvelopeID($envelopeID)
            ->setLanguage($language)
            ->setTemplateKeyValue($templateKeyValue)
            ->setTemplateType($templateType);
    }
    /**
     * Get DealerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerNumber()
    {
        return isset($this->DealerNumber) ? $this->DealerNumber : null;
    }
    /**
     * Set DealerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerNumber
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setDealerNumber($dealerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dealerNumber) && !is_string($dealerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerNumber)), __LINE__);
        }
        if (is_null($dealerNumber) || (is_array($dealerNumber) && empty($dealerNumber))) {
            unset($this->DealerNumber);
        } else {
            $this->DealerNumber = $dealerNumber;
        }
        return $this;
    }
    /**
     * Get DocSignatures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eContract\ArrayType\ArrayOfDocumentSignatures|null
     */
    public function getDocSignatures()
    {
        return isset($this->DocSignatures) ? $this->DocSignatures : null;
    }
    /**
     * Set DocSignatures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \eContract\ArrayType\ArrayOfDocumentSignatures $docSignatures
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setDocSignatures(\eContract\ArrayType\ArrayOfDocumentSignatures $docSignatures = null)
    {
        if (is_null($docSignatures) || (is_array($docSignatures) && empty($docSignatures))) {
            unset($this->DocSignatures);
        } else {
            $this->DocSignatures = $docSignatures;
        }
        return $this;
    }
    /**
     * Get EmailBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBody()
    {
        return isset($this->EmailBody) ? $this->EmailBody : null;
    }
    /**
     * Set EmailBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBody
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setEmailBody($emailBody = null)
    {
        // validation for constraint: string
        if (!is_null($emailBody) && !is_string($emailBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailBody)), __LINE__);
        }
        if (is_null($emailBody) || (is_array($emailBody) && empty($emailBody))) {
            unset($this->EmailBody);
        } else {
            $this->EmailBody = $emailBody;
        }
        return $this;
    }
    /**
     * Get EmailReplyToOverrideEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailReplyToOverrideEmail()
    {
        return isset($this->EmailReplyToOverrideEmail) ? $this->EmailReplyToOverrideEmail : null;
    }
    /**
     * Set EmailReplyToOverrideEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailReplyToOverrideEmail
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setEmailReplyToOverrideEmail($emailReplyToOverrideEmail = null)
    {
        // validation for constraint: string
        if (!is_null($emailReplyToOverrideEmail) && !is_string($emailReplyToOverrideEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailReplyToOverrideEmail)), __LINE__);
        }
        if (is_null($emailReplyToOverrideEmail) || (is_array($emailReplyToOverrideEmail) && empty($emailReplyToOverrideEmail))) {
            unset($this->EmailReplyToOverrideEmail);
        } else {
            $this->EmailReplyToOverrideEmail = $emailReplyToOverrideEmail;
        }
        return $this;
    }
    /**
     * Get EmailReplyToOverrideName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailReplyToOverrideName()
    {
        return isset($this->EmailReplyToOverrideName) ? $this->EmailReplyToOverrideName : null;
    }
    /**
     * Set EmailReplyToOverrideName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailReplyToOverrideName
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setEmailReplyToOverrideName($emailReplyToOverrideName = null)
    {
        // validation for constraint: string
        if (!is_null($emailReplyToOverrideName) && !is_string($emailReplyToOverrideName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailReplyToOverrideName)), __LINE__);
        }
        if (is_null($emailReplyToOverrideName) || (is_array($emailReplyToOverrideName) && empty($emailReplyToOverrideName))) {
            unset($this->EmailReplyToOverrideName);
        } else {
            $this->EmailReplyToOverrideName = $emailReplyToOverrideName;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSubject
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSubject)), __LINE__);
        }
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get EnvelopeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeID()
    {
        return isset($this->EnvelopeID) ? $this->EnvelopeID : null;
    }
    /**
     * Set EnvelopeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeID
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setEnvelopeID($envelopeID = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeID) && !is_string($envelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envelopeID)), __LINE__);
        }
        if (is_null($envelopeID) || (is_array($envelopeID) && empty($envelopeID))) {
            unset($this->EnvelopeID);
        } else {
            $this->EnvelopeID = $envelopeID;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get TemplateKeyValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplateKeyValue()
    {
        return isset($this->TemplateKeyValue) ? $this->TemplateKeyValue : null;
    }
    /**
     * Set TemplateKeyValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $templateKeyValue
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setTemplateKeyValue($templateKeyValue = null)
    {
        // validation for constraint: string
        if (!is_null($templateKeyValue) && !is_string($templateKeyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateKeyValue)), __LINE__);
        }
        if (is_null($templateKeyValue) || (is_array($templateKeyValue) && empty($templateKeyValue))) {
            unset($this->TemplateKeyValue);
        } else {
            $this->TemplateKeyValue = $templateKeyValue;
        }
        return $this;
    }
    /**
     * Get TemplateType value
     * @return string|null
     */
    public function getTemplateType()
    {
        return $this->TemplateType;
    }
    /**
     * Set TemplateType value
     * @uses \eContract\EnumType\DocuSignTemplateTypes::valueIsValid()
     * @uses \eContract\EnumType\DocuSignTemplateTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $templateType
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public function setTemplateType($templateType = null)
    {
        // validation for constraint: enumeration
        if (!\eContract\EnumType\DocuSignTemplateTypes::valueIsValid($templateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $templateType, implode(', ', \eContract\EnumType\DocuSignTemplateTypes::getValidValues())), __LINE__);
        }
        $this->TemplateType = $templateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\StructType\DocuSignTemplateBaseObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
