<?php

namespace eContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocuSignTemplateNonSolicitAgreement StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DocuSignTemplateNonSolicitAgreement
 * @subpackage Structs
 */
class DocuSignTemplateNonSolicitAgreement extends DocuSignTemplateBaseObject
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The DealerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerName;
    /**
     * The DealerPortalUsername
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerPortalUsername;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for DocuSignTemplateNonSolicitAgreement
     * @uses DocuSignTemplateNonSolicitAgreement::setAddress()
     * @uses DocuSignTemplateNonSolicitAgreement::setCity()
     * @uses DocuSignTemplateNonSolicitAgreement::setDealerName()
     * @uses DocuSignTemplateNonSolicitAgreement::setDealerPortalUsername()
     * @uses DocuSignTemplateNonSolicitAgreement::setState()
     * @uses DocuSignTemplateNonSolicitAgreement::setZip()
     * @param string $address
     * @param string $city
     * @param string $dealerName
     * @param string $dealerPortalUsername
     * @param string $state
     * @param string $zip
     */
    public function __construct($address = null, $city = null, $dealerName = null, $dealerPortalUsername = null, $state = null, $zip = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setDealerName($dealerName)
            ->setDealerPortalUsername($dealerPortalUsername)
            ->setState($state)
            ->setZip($zip);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get DealerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerName()
    {
        return isset($this->DealerName) ? $this->DealerName : null;
    }
    /**
     * Set DealerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerName
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setDealerName($dealerName = null)
    {
        // validation for constraint: string
        if (!is_null($dealerName) && !is_string($dealerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerName)), __LINE__);
        }
        if (is_null($dealerName) || (is_array($dealerName) && empty($dealerName))) {
            unset($this->DealerName);
        } else {
            $this->DealerName = $dealerName;
        }
        return $this;
    }
    /**
     * Get DealerPortalUsername value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerPortalUsername()
    {
        return isset($this->DealerPortalUsername) ? $this->DealerPortalUsername : null;
    }
    /**
     * Set DealerPortalUsername value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerPortalUsername
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setDealerPortalUsername($dealerPortalUsername = null)
    {
        // validation for constraint: string
        if (!is_null($dealerPortalUsername) && !is_string($dealerPortalUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerPortalUsername)), __LINE__);
        }
        if (is_null($dealerPortalUsername) || (is_array($dealerPortalUsername) && empty($dealerPortalUsername))) {
            unset($this->DealerPortalUsername);
        } else {
            $this->DealerPortalUsername = $dealerPortalUsername;
        }
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \eContract\EnumType\StateProvinceEnum::valueIsValid()
     * @uses \eContract\EnumType\StateProvinceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\eContract\EnumType\StateProvinceEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \eContract\EnumType\StateProvinceEnum::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\StructType\DocuSignTemplateNonSolicitAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
