<?php

namespace eContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocuSignTemplateCreditAuthDocument StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DocuSignTemplateCreditAuthDocument
 * @subpackage Structs
 */
class DocuSignTemplateCreditAuthDocument extends DocuSignTemplateBaseObject
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The DealerPortalPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerPortalPassword;
    /**
     * The DealerPortalUsername
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerPortalUsername;
    /**
     * The DocumentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentStatus;
    /**
     * The PrimaryBirthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryBirthDate;
    /**
     * The PrimaryPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryPhone;
    /**
     * The PrimaryTaxIDNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryTaxIDNumber;
    /**
     * The ProspectID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProspectID;
    /**
     * The SecondaryBirthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryBirthDate;
    /**
     * The SecondaryPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryPhone;
    /**
     * The SecondaryTaxIDNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryTaxIDNumber;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for DocuSignTemplateCreditAuthDocument
     * @uses DocuSignTemplateCreditAuthDocument::setAddress()
     * @uses DocuSignTemplateCreditAuthDocument::setCity()
     * @uses DocuSignTemplateCreditAuthDocument::setDealerPortalPassword()
     * @uses DocuSignTemplateCreditAuthDocument::setDealerPortalUsername()
     * @uses DocuSignTemplateCreditAuthDocument::setDocumentStatus()
     * @uses DocuSignTemplateCreditAuthDocument::setPrimaryBirthDate()
     * @uses DocuSignTemplateCreditAuthDocument::setPrimaryPhone()
     * @uses DocuSignTemplateCreditAuthDocument::setPrimaryTaxIDNumber()
     * @uses DocuSignTemplateCreditAuthDocument::setProspectID()
     * @uses DocuSignTemplateCreditAuthDocument::setSecondaryBirthDate()
     * @uses DocuSignTemplateCreditAuthDocument::setSecondaryPhone()
     * @uses DocuSignTemplateCreditAuthDocument::setSecondaryTaxIDNumber()
     * @uses DocuSignTemplateCreditAuthDocument::setState()
     * @uses DocuSignTemplateCreditAuthDocument::setZip()
     * @param string $address
     * @param string $city
     * @param string $dealerPortalPassword
     * @param string $dealerPortalUsername
     * @param string $documentStatus
     * @param string $primaryBirthDate
     * @param string $primaryPhone
     * @param string $primaryTaxIDNumber
     * @param string $prospectID
     * @param string $secondaryBirthDate
     * @param string $secondaryPhone
     * @param string $secondaryTaxIDNumber
     * @param string $state
     * @param string $zip
     */
    public function __construct($address = null, $city = null, $dealerPortalPassword = null, $dealerPortalUsername = null, $documentStatus = null, $primaryBirthDate = null, $primaryPhone = null, $primaryTaxIDNumber = null, $prospectID = null, $secondaryBirthDate = null, $secondaryPhone = null, $secondaryTaxIDNumber = null, $state = null, $zip = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setDealerPortalPassword($dealerPortalPassword)
            ->setDealerPortalUsername($dealerPortalUsername)
            ->setDocumentStatus($documentStatus)
            ->setPrimaryBirthDate($primaryBirthDate)
            ->setPrimaryPhone($primaryPhone)
            ->setPrimaryTaxIDNumber($primaryTaxIDNumber)
            ->setProspectID($prospectID)
            ->setSecondaryBirthDate($secondaryBirthDate)
            ->setSecondaryPhone($secondaryPhone)
            ->setSecondaryTaxIDNumber($secondaryTaxIDNumber)
            ->setState($state)
            ->setZip($zip);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get DealerPortalPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerPortalPassword()
    {
        return isset($this->DealerPortalPassword) ? $this->DealerPortalPassword : null;
    }
    /**
     * Set DealerPortalPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerPortalPassword
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setDealerPortalPassword($dealerPortalPassword = null)
    {
        // validation for constraint: string
        if (!is_null($dealerPortalPassword) && !is_string($dealerPortalPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerPortalPassword)), __LINE__);
        }
        if (is_null($dealerPortalPassword) || (is_array($dealerPortalPassword) && empty($dealerPortalPassword))) {
            unset($this->DealerPortalPassword);
        } else {
            $this->DealerPortalPassword = $dealerPortalPassword;
        }
        return $this;
    }
    /**
     * Get DealerPortalUsername value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerPortalUsername()
    {
        return isset($this->DealerPortalUsername) ? $this->DealerPortalUsername : null;
    }
    /**
     * Set DealerPortalUsername value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerPortalUsername
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setDealerPortalUsername($dealerPortalUsername = null)
    {
        // validation for constraint: string
        if (!is_null($dealerPortalUsername) && !is_string($dealerPortalUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerPortalUsername)), __LINE__);
        }
        if (is_null($dealerPortalUsername) || (is_array($dealerPortalUsername) && empty($dealerPortalUsername))) {
            unset($this->DealerPortalUsername);
        } else {
            $this->DealerPortalUsername = $dealerPortalUsername;
        }
        return $this;
    }
    /**
     * Get DocumentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentStatus()
    {
        return isset($this->DocumentStatus) ? $this->DocumentStatus : null;
    }
    /**
     * Set DocumentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentStatus
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($documentStatus) && !is_string($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentStatus)), __LINE__);
        }
        if (is_null($documentStatus) || (is_array($documentStatus) && empty($documentStatus))) {
            unset($this->DocumentStatus);
        } else {
            $this->DocumentStatus = $documentStatus;
        }
        return $this;
    }
    /**
     * Get PrimaryBirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryBirthDate()
    {
        return isset($this->PrimaryBirthDate) ? $this->PrimaryBirthDate : null;
    }
    /**
     * Set PrimaryBirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryBirthDate
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setPrimaryBirthDate($primaryBirthDate = null)
    {
        // validation for constraint: string
        if (!is_null($primaryBirthDate) && !is_string($primaryBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryBirthDate)), __LINE__);
        }
        if (is_null($primaryBirthDate) || (is_array($primaryBirthDate) && empty($primaryBirthDate))) {
            unset($this->PrimaryBirthDate);
        } else {
            $this->PrimaryBirthDate = $primaryBirthDate;
        }
        return $this;
    }
    /**
     * Get PrimaryPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryPhone()
    {
        return isset($this->PrimaryPhone) ? $this->PrimaryPhone : null;
    }
    /**
     * Set PrimaryPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryPhone
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setPrimaryPhone($primaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPhone) && !is_string($primaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPhone)), __LINE__);
        }
        if (is_null($primaryPhone) || (is_array($primaryPhone) && empty($primaryPhone))) {
            unset($this->PrimaryPhone);
        } else {
            $this->PrimaryPhone = $primaryPhone;
        }
        return $this;
    }
    /**
     * Get PrimaryTaxIDNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryTaxIDNumber()
    {
        return isset($this->PrimaryTaxIDNumber) ? $this->PrimaryTaxIDNumber : null;
    }
    /**
     * Set PrimaryTaxIDNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryTaxIDNumber
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setPrimaryTaxIDNumber($primaryTaxIDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTaxIDNumber) && !is_string($primaryTaxIDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryTaxIDNumber)), __LINE__);
        }
        if (is_null($primaryTaxIDNumber) || (is_array($primaryTaxIDNumber) && empty($primaryTaxIDNumber))) {
            unset($this->PrimaryTaxIDNumber);
        } else {
            $this->PrimaryTaxIDNumber = $primaryTaxIDNumber;
        }
        return $this;
    }
    /**
     * Get ProspectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProspectID()
    {
        return isset($this->ProspectID) ? $this->ProspectID : null;
    }
    /**
     * Set ProspectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prospectID
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setProspectID($prospectID = null)
    {
        // validation for constraint: string
        if (!is_null($prospectID) && !is_string($prospectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prospectID)), __LINE__);
        }
        if (is_null($prospectID) || (is_array($prospectID) && empty($prospectID))) {
            unset($this->ProspectID);
        } else {
            $this->ProspectID = $prospectID;
        }
        return $this;
    }
    /**
     * Get SecondaryBirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryBirthDate()
    {
        return isset($this->SecondaryBirthDate) ? $this->SecondaryBirthDate : null;
    }
    /**
     * Set SecondaryBirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryBirthDate
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setSecondaryBirthDate($secondaryBirthDate = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryBirthDate) && !is_string($secondaryBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryBirthDate)), __LINE__);
        }
        if (is_null($secondaryBirthDate) || (is_array($secondaryBirthDate) && empty($secondaryBirthDate))) {
            unset($this->SecondaryBirthDate);
        } else {
            $this->SecondaryBirthDate = $secondaryBirthDate;
        }
        return $this;
    }
    /**
     * Get SecondaryPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryPhone()
    {
        return isset($this->SecondaryPhone) ? $this->SecondaryPhone : null;
    }
    /**
     * Set SecondaryPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryPhone
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setSecondaryPhone($secondaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryPhone) && !is_string($secondaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryPhone)), __LINE__);
        }
        if (is_null($secondaryPhone) || (is_array($secondaryPhone) && empty($secondaryPhone))) {
            unset($this->SecondaryPhone);
        } else {
            $this->SecondaryPhone = $secondaryPhone;
        }
        return $this;
    }
    /**
     * Get SecondaryTaxIDNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryTaxIDNumber()
    {
        return isset($this->SecondaryTaxIDNumber) ? $this->SecondaryTaxIDNumber : null;
    }
    /**
     * Set SecondaryTaxIDNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryTaxIDNumber
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setSecondaryTaxIDNumber($secondaryTaxIDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTaxIDNumber) && !is_string($secondaryTaxIDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryTaxIDNumber)), __LINE__);
        }
        if (is_null($secondaryTaxIDNumber) || (is_array($secondaryTaxIDNumber) && empty($secondaryTaxIDNumber))) {
            unset($this->SecondaryTaxIDNumber);
        } else {
            $this->SecondaryTaxIDNumber = $secondaryTaxIDNumber;
        }
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \eContract\EnumType\StateProvinceEnum::valueIsValid()
     * @uses \eContract\EnumType\StateProvinceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\eContract\EnumType\StateProvinceEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \eContract\EnumType\StateProvinceEnum::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\StructType\DocuSignTemplateCreditAuthDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
