<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \eContract\ClassMap::get(),
);
/**
 * Samples for APIV ServiceType
 */
$aPIV = new \eContract\ServiceType\APIV($options);
/**
 * Sample call for APIVersion operation/method
 */
if ($aPIV->APIVersion(new \eContract\StructType\APIVersion()) !== false) {
    print_r($aPIV->getResult());
} else {
    print_r($aPIV->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \eContract\ServiceType\Authenticate($options);
/**
 * Sample call for AuthenticateUser operation/method
 */
if ($authenticate->AuthenticateUser(new \eContract\StructType\AuthenticateUser()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for AuthenticateUser2 operation/method
 */
if ($authenticate->AuthenticateUser2(new \eContract\StructType\AuthenticateUser2()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \eContract\ServiceType\Search($options);
/**
 * Sample call for SearchContracts operation/method
 */
if ($search->SearchContracts(new \eContract\StructType\SearchContracts()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchCreditAuth operation/method
 */
if ($search->SearchCreditAuth(new \eContract\StructType\SearchCreditAuth()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \eContract\ServiceType\Create($options);
/**
 * Sample call for CreateContract operation/method
 */
if ($create->CreateContract(new \eContract\StructType\CreateContract()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateContract2 operation/method
 */
if ($create->CreateContract2(new \eContract\StructType\CreateContract2()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateContractConsumer operation/method
 */
if ($create->CreateContractConsumer(new \eContract\StructType\CreateContractConsumer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Next ServiceType
 */
$next = new \eContract\ServiceType\Next($options);
/**
 * Sample call for NextSigner operation/method
 */
if ($next->NextSigner(new \eContract\StructType\NextSigner()) !== false) {
    print_r($next->getResult());
} else {
    print_r($next->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \eContract\ServiceType\Void($options);
/**
 * Sample call for VoidContract operation/method
 */
if ($void->VoidContract(new \eContract\StructType\VoidContract()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \eContract\ServiceType\Get($options);
/**
 * Sample call for GetContract operation/method
 */
if ($get->GetContract(new \eContract\StructType\GetContract()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractAsPrimary operation/method
 */
if ($get->GetContractAsPrimary(new \eContract\StructType\GetContractAsPrimary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractDocumentConsumer operation/method
 */
if ($get->GetContractDocumentConsumer(new \eContract\StructType\GetContractDocumentConsumer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContractID operation/method
 */
if ($get->GetContractID(new \eContract\StructType\GetContractID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPerformCallbackToPartnerAPIFlag operation/method
 */
if ($get->GetPerformCallbackToPartnerAPIFlag(new \eContract\StructType\GetPerformCallbackToPartnerAPIFlag()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \eContract\ServiceType\Send($options);
/**
 * Sample call for SendQuoteEmail operation/method
 */
if ($send->SendQuoteEmail(new \eContract\StructType\SendQuoteEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendQuoteEmail2 operation/method
 */
if ($send->SendQuoteEmail2(new \eContract\StructType\SendQuoteEmail2()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendNonSolicitAgreement operation/method
 */
if ($send->SendNonSolicitAgreement(new \eContract\StructType\SendNonSolicitAgreement()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendCreditAuthorization operation/method
 */
if ($send->SendCreditAuthorization(new \eContract\StructType\SendCreditAuthorization()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendCancelLetter operation/method
 */
if ($send->SendCancelLetter(new \eContract\StructType\SendCancelLetter()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \eContract\ServiceType\Validate($options);
/**
 * Sample call for ValidateContract2 operation/method
 */
if ($validate->ValidateContract2(new \eContract\StructType\ValidateContract2()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \eContract\ServiceType\Upload($options);
/**
 * Sample call for UploadAttachment operation/method
 */
if ($upload->UploadAttachment(new \eContract\StructType\UploadAttachment()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \eContract\ServiceType\Delete($options);
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($delete->DeleteAttachment(new \eContract\StructType\DeleteAttachment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \eContract\ServiceType\Register($options);
/**
 * Sample call for RegisterNotificationUrl operation/method
 */
if ($register->RegisterNotificationUrl(new \eContract\StructType\RegisterNotificationUrl()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Contract ServiceType
 */
$contract = new \eContract\ServiceType\Contract($options);
/**
 * Sample call for ContractReadyForArchival operation/method
 */
if ($contract->ContractReadyForArchival(new \eContract\StructType\ContractReadyForArchival()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Samples for Resend ServiceType
 */
$resend = new \eContract\ServiceType\Resend($options);
/**
 * Sample call for ResendEnvelope operation/method
 */
if ($resend->ResendEnvelope(new \eContract\StructType\ResendEnvelope()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
