<?php

namespace MoniContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResendEnvelope StructType
 * @subpackage Structs
 */
class ResendEnvelope extends AbstractStructBase
{
    /**
     * The EnvelopeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvelopeID;
    /**
     * The NewEmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewEmailAddress;
    /**
     * The NewRecipientFullName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewRecipientFullName;
    /**
     * The Role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Role;
    /**
     * Constructor method for ResendEnvelope
     * @uses ResendEnvelope::setEnvelopeID()
     * @uses ResendEnvelope::setNewEmailAddress()
     * @uses ResendEnvelope::setNewRecipientFullName()
     * @uses ResendEnvelope::setRole()
     * @param string $envelopeID
     * @param string $newEmailAddress
     * @param string $newRecipientFullName
     * @param string $role
     */
    public function __construct($envelopeID = null, $newEmailAddress = null, $newRecipientFullName = null, $role = null)
    {
        $this
            ->setEnvelopeID($envelopeID)
            ->setNewEmailAddress($newEmailAddress)
            ->setNewRecipientFullName($newRecipientFullName)
            ->setRole($role);
    }
    /**
     * Get EnvelopeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeID()
    {
        return isset($this->EnvelopeID) ? $this->EnvelopeID : null;
    }
    /**
     * Set EnvelopeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeID
     * @return \MoniContract\StructType\ResendEnvelope
     */
    public function setEnvelopeID($envelopeID = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeID) && !is_string($envelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envelopeID)), __LINE__);
        }
        if (is_null($envelopeID) || (is_array($envelopeID) && empty($envelopeID))) {
            unset($this->EnvelopeID);
        } else {
            $this->EnvelopeID = $envelopeID;
        }
        return $this;
    }
    /**
     * Get NewEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewEmailAddress()
    {
        return isset($this->NewEmailAddress) ? $this->NewEmailAddress : null;
    }
    /**
     * Set NewEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newEmailAddress
     * @return \MoniContract\StructType\ResendEnvelope
     */
    public function setNewEmailAddress($newEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newEmailAddress) && !is_string($newEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newEmailAddress)), __LINE__);
        }
        if (is_null($newEmailAddress) || (is_array($newEmailAddress) && empty($newEmailAddress))) {
            unset($this->NewEmailAddress);
        } else {
            $this->NewEmailAddress = $newEmailAddress;
        }
        return $this;
    }
    /**
     * Get NewRecipientFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewRecipientFullName()
    {
        return isset($this->NewRecipientFullName) ? $this->NewRecipientFullName : null;
    }
    /**
     * Set NewRecipientFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newRecipientFullName
     * @return \MoniContract\StructType\ResendEnvelope
     */
    public function setNewRecipientFullName($newRecipientFullName = null)
    {
        // validation for constraint: string
        if (!is_null($newRecipientFullName) && !is_string($newRecipientFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newRecipientFullName)), __LINE__);
        }
        if (is_null($newRecipientFullName) || (is_array($newRecipientFullName) && empty($newRecipientFullName))) {
            unset($this->NewRecipientFullName);
        } else {
            $this->NewRecipientFullName = $newRecipientFullName;
        }
        return $this;
    }
    /**
     * Get Role value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRole()
    {
        return isset($this->Role) ? $this->Role : null;
    }
    /**
     * Set Role value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $role
     * @return \MoniContract\StructType\ResendEnvelope
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        if (is_null($role) || (is_array($role) && empty($role))) {
            unset($this->Role);
        } else {
            $this->Role = $role;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\StructType\ResendEnvelope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
