<?php

namespace MoniContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractDocumentConsumer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractDocumentConsumer
 * @subpackage Structs
 */
class ContractDocumentConsumer extends ContractDocument2
{
    /**
     * The ContractEmailSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractEmailSubject;
    /**
     * The ContractTemplateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContractTemplateType;
    /**
     * The ContractVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractVersion;
    /**
     * The DealerNameOverride
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerNameOverride;
    /**
     * The DealerNumberOverride
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerNumberOverride;
    /**
     * The DealerSalespersonNameOverride
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DealerSalespersonNameOverride;
    /**
     * The PerformCallbackToPartnerAPI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PerformCallbackToPartnerAPI;
    /**
     * The TaxExemptID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptID;
    /**
     * Constructor method for ContractDocumentConsumer
     * @uses ContractDocumentConsumer::setContractEmailSubject()
     * @uses ContractDocumentConsumer::setContractTemplateType()
     * @uses ContractDocumentConsumer::setContractVersion()
     * @uses ContractDocumentConsumer::setDealerNameOverride()
     * @uses ContractDocumentConsumer::setDealerNumberOverride()
     * @uses ContractDocumentConsumer::setDealerSalespersonNameOverride()
     * @uses ContractDocumentConsumer::setPerformCallbackToPartnerAPI()
     * @uses ContractDocumentConsumer::setTaxExemptID()
     * @param string $contractEmailSubject
     * @param string $contractTemplateType
     * @param string $contractVersion
     * @param string $dealerNameOverride
     * @param string $dealerNumberOverride
     * @param string $dealerSalespersonNameOverride
     * @param bool $performCallbackToPartnerAPI
     * @param string $taxExemptID
     */
    public function __construct($contractEmailSubject = null, $contractTemplateType = null, $contractVersion = null, $dealerNameOverride = null, $dealerNumberOverride = null, $dealerSalespersonNameOverride = null, $performCallbackToPartnerAPI = null, $taxExemptID = null)
    {
        $this
            ->setContractEmailSubject($contractEmailSubject)
            ->setContractTemplateType($contractTemplateType)
            ->setContractVersion($contractVersion)
            ->setDealerNameOverride($dealerNameOverride)
            ->setDealerNumberOverride($dealerNumberOverride)
            ->setDealerSalespersonNameOverride($dealerSalespersonNameOverride)
            ->setPerformCallbackToPartnerAPI($performCallbackToPartnerAPI)
            ->setTaxExemptID($taxExemptID);
    }
    /**
     * Get ContractEmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractEmailSubject()
    {
        return isset($this->ContractEmailSubject) ? $this->ContractEmailSubject : null;
    }
    /**
     * Set ContractEmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractEmailSubject
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setContractEmailSubject($contractEmailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($contractEmailSubject) && !is_string($contractEmailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractEmailSubject)), __LINE__);
        }
        if (is_null($contractEmailSubject) || (is_array($contractEmailSubject) && empty($contractEmailSubject))) {
            unset($this->ContractEmailSubject);
        } else {
            $this->ContractEmailSubject = $contractEmailSubject;
        }
        return $this;
    }
    /**
     * Get ContractTemplateType value
     * @return string|null
     */
    public function getContractTemplateType()
    {
        return $this->ContractTemplateType;
    }
    /**
     * Set ContractTemplateType value
     * @uses \MoniContract\EnumType\ContractTemplateTypes::valueIsValid()
     * @uses \MoniContract\EnumType\ContractTemplateTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractTemplateType
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setContractTemplateType($contractTemplateType = null)
    {
        // validation for constraint: enumeration
        if (!\MoniContract\EnumType\ContractTemplateTypes::valueIsValid($contractTemplateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contractTemplateType, implode(', ', \MoniContract\EnumType\ContractTemplateTypes::getValidValues())), __LINE__);
        }
        $this->ContractTemplateType = $contractTemplateType;
        return $this;
    }
    /**
     * Get ContractVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractVersion()
    {
        return isset($this->ContractVersion) ? $this->ContractVersion : null;
    }
    /**
     * Set ContractVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractVersion
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setContractVersion($contractVersion = null)
    {
        // validation for constraint: string
        if (!is_null($contractVersion) && !is_string($contractVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractVersion)), __LINE__);
        }
        if (is_null($contractVersion) || (is_array($contractVersion) && empty($contractVersion))) {
            unset($this->ContractVersion);
        } else {
            $this->ContractVersion = $contractVersion;
        }
        return $this;
    }
    /**
     * Get DealerNameOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerNameOverride()
    {
        return isset($this->DealerNameOverride) ? $this->DealerNameOverride : null;
    }
    /**
     * Set DealerNameOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerNameOverride
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setDealerNameOverride($dealerNameOverride = null)
    {
        // validation for constraint: string
        if (!is_null($dealerNameOverride) && !is_string($dealerNameOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerNameOverride)), __LINE__);
        }
        if (is_null($dealerNameOverride) || (is_array($dealerNameOverride) && empty($dealerNameOverride))) {
            unset($this->DealerNameOverride);
        } else {
            $this->DealerNameOverride = $dealerNameOverride;
        }
        return $this;
    }
    /**
     * Get DealerNumberOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerNumberOverride()
    {
        return isset($this->DealerNumberOverride) ? $this->DealerNumberOverride : null;
    }
    /**
     * Set DealerNumberOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerNumberOverride
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setDealerNumberOverride($dealerNumberOverride = null)
    {
        // validation for constraint: string
        if (!is_null($dealerNumberOverride) && !is_string($dealerNumberOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerNumberOverride)), __LINE__);
        }
        if (is_null($dealerNumberOverride) || (is_array($dealerNumberOverride) && empty($dealerNumberOverride))) {
            unset($this->DealerNumberOverride);
        } else {
            $this->DealerNumberOverride = $dealerNumberOverride;
        }
        return $this;
    }
    /**
     * Get DealerSalespersonNameOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerSalespersonNameOverride()
    {
        return isset($this->DealerSalespersonNameOverride) ? $this->DealerSalespersonNameOverride : null;
    }
    /**
     * Set DealerSalespersonNameOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerSalespersonNameOverride
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setDealerSalespersonNameOverride($dealerSalespersonNameOverride = null)
    {
        // validation for constraint: string
        if (!is_null($dealerSalespersonNameOverride) && !is_string($dealerSalespersonNameOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerSalespersonNameOverride)), __LINE__);
        }
        if (is_null($dealerSalespersonNameOverride) || (is_array($dealerSalespersonNameOverride) && empty($dealerSalespersonNameOverride))) {
            unset($this->DealerSalespersonNameOverride);
        } else {
            $this->DealerSalespersonNameOverride = $dealerSalespersonNameOverride;
        }
        return $this;
    }
    /**
     * Get PerformCallbackToPartnerAPI value
     * @return bool|null
     */
    public function getPerformCallbackToPartnerAPI()
    {
        return $this->PerformCallbackToPartnerAPI;
    }
    /**
     * Set PerformCallbackToPartnerAPI value
     * @param bool $performCallbackToPartnerAPI
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setPerformCallbackToPartnerAPI($performCallbackToPartnerAPI = null)
    {
        // validation for constraint: boolean
        if (!is_null($performCallbackToPartnerAPI) && !is_bool($performCallbackToPartnerAPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($performCallbackToPartnerAPI)), __LINE__);
        }
        $this->PerformCallbackToPartnerAPI = $performCallbackToPartnerAPI;
        return $this;
    }
    /**
     * Get TaxExemptID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptID()
    {
        return isset($this->TaxExemptID) ? $this->TaxExemptID : null;
    }
    /**
     * Set TaxExemptID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptID
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public function setTaxExemptID($taxExemptID = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptID) && !is_string($taxExemptID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxExemptID)), __LINE__);
        }
        if (is_null($taxExemptID) || (is_array($taxExemptID) && empty($taxExemptID))) {
            unset($this->TaxExemptID);
        } else {
            $this->TaxExemptID = $taxExemptID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\StructType\ContractDocumentConsumer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
