<?php

namespace MoniContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchContracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SearchContracts $parameters
     * @return \MoniContract\StructType\SearchContractsResponse|bool
     */
    public function SearchContracts(\MoniContract\StructType\SearchContracts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchContracts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchCreditAuth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SearchCreditAuth $parameters
     * @return \MoniContract\StructType\SearchCreditAuthResponse|bool
     */
    public function SearchCreditAuth(\MoniContract\StructType\SearchCreditAuth $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchCreditAuth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniContract\StructType\SearchContractsResponse|\MoniContract\StructType\SearchCreditAuthResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
