<?php

namespace MoniContract\EnumType;

/**
 * This class stands for DocuSignTemplateTypes EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DocuSignTemplateTypes
 * @subpackage Enumerations
 */
class DocuSignTemplateTypes
{
    /**
     * Constant for value 'NonSolicitAgreement'
     * @return string 'NonSolicitAgreement'
     */
    const VALUE_NON_SOLICIT_AGREEMENT = 'NonSolicitAgreement';
    /**
     * Constant for value 'CreditAuthorization'
     * @return string 'CreditAuthorization'
     */
    const VALUE_CREDIT_AUTHORIZATION = 'CreditAuthorization';
    /**
     * Constant for value 'CancelLetter'
     * @return string 'CancelLetter'
     */
    const VALUE_CANCEL_LETTER = 'CancelLetter';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_SOLICIT_AGREEMENT
     * @uses self::VALUE_CREDIT_AUTHORIZATION
     * @uses self::VALUE_CANCEL_LETTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_SOLICIT_AGREEMENT,
            self::VALUE_CREDIT_AUTHORIZATION,
            self::VALUE_CANCEL_LETTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
