<?php

namespace MoniContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resend ServiceType
 * @subpackage Services
 */
class Resend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResendEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\ResendEnvelope $parameters
     * @return \MoniContract\StructType\ResendEnvelopeResponse|bool
     */
    public function ResendEnvelope(\MoniContract\StructType\ResendEnvelope $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ResendEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniContract\StructType\ResendEnvelopeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
