<?php

namespace MoniContract\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCreditAuthHeader ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCreditAuthHeader
 * @subpackage Arrays
 */
class ArrayOfCreditAuthHeader extends AbstractStructArrayBase
{
    /**
     * The CreditAuthHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniContract\StructType\CreditAuthHeader[]
     */
    public $CreditAuthHeader;
    /**
     * Constructor method for ArrayOfCreditAuthHeader
     * @uses ArrayOfCreditAuthHeader::setCreditAuthHeader()
     * @param \MoniContract\StructType\CreditAuthHeader[] $creditAuthHeader
     */
    public function __construct(array $creditAuthHeader = array())
    {
        $this
            ->setCreditAuthHeader($creditAuthHeader);
    }
    /**
     * Get CreditAuthHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniContract\StructType\CreditAuthHeader[]|null
     */
    public function getCreditAuthHeader()
    {
        return isset($this->CreditAuthHeader) ? $this->CreditAuthHeader : null;
    }
    /**
     * Set CreditAuthHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MoniContract\StructType\CreditAuthHeader[] $creditAuthHeader
     * @return \MoniContract\ArrayType\ArrayOfCreditAuthHeader
     */
    public function setCreditAuthHeader(array $creditAuthHeader = array())
    {
        foreach ($creditAuthHeader as $arrayOfCreditAuthHeaderCreditAuthHeaderItem) {
            // validation for constraint: itemType
            if (!$arrayOfCreditAuthHeaderCreditAuthHeaderItem instanceof \MoniContract\StructType\CreditAuthHeader) {
                throw new \InvalidArgumentException(sprintf('The CreditAuthHeader property can only contain items of \MoniContract\StructType\CreditAuthHeader, "%s" given', is_object($arrayOfCreditAuthHeaderCreditAuthHeaderItem) ? get_class($arrayOfCreditAuthHeaderCreditAuthHeaderItem) : gettype($arrayOfCreditAuthHeaderCreditAuthHeaderItem)), __LINE__);
            }
        }
        if (is_null($creditAuthHeader) || (is_array($creditAuthHeader) && empty($creditAuthHeader))) {
            unset($this->CreditAuthHeader);
        } else {
            $this->CreditAuthHeader = $creditAuthHeader;
        }
        return $this;
    }
    /**
     * Add item to CreditAuthHeader value
     * @throws \InvalidArgumentException
     * @param \MoniContract\StructType\CreditAuthHeader $item
     * @return \MoniContract\ArrayType\ArrayOfCreditAuthHeader
     */
    public function addToCreditAuthHeader(\MoniContract\StructType\CreditAuthHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MoniContract\StructType\CreditAuthHeader) {
            throw new \InvalidArgumentException(sprintf('The CreditAuthHeader property can only contain items of \MoniContract\StructType\CreditAuthHeader, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreditAuthHeader[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MoniContract\StructType\CreditAuthHeader|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MoniContract\StructType\CreditAuthHeader|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MoniContract\StructType\CreditAuthHeader|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MoniContract\StructType\CreditAuthHeader|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MoniContract\StructType\CreditAuthHeader|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CreditAuthHeader
     */
    public function getAttributeName()
    {
        return 'CreditAuthHeader';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\ArrayType\ArrayOfCreditAuthHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
