<?php

namespace MoniContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Void ServiceType
 * @subpackage Services
 */
class Void extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VoidContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\VoidContract $parameters
     * @return \MoniContract\StructType\VoidContractResponse|bool
     */
    public function VoidContract(\MoniContract\StructType\VoidContract $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VoidContract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniContract\StructType\VoidContractResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
