<?php

namespace eContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendQuoteEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\SendQuoteEmail $parameters
     * @return \eContract\StructType\SendQuoteEmailResponse|bool
     */
    public function SendQuoteEmail(\eContract\StructType\SendQuoteEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendQuoteEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendQuoteEmail2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\SendQuoteEmail2 $parameters
     * @return \eContract\StructType\SendQuoteEmail2Response|bool
     */
    public function SendQuoteEmail2(\eContract\StructType\SendQuoteEmail2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendQuoteEmail2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendNonSolicitAgreement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\SendNonSolicitAgreement $parameters
     * @return \eContract\StructType\SendNonSolicitAgreementResponse|bool
     */
    public function SendNonSolicitAgreement(\eContract\StructType\SendNonSolicitAgreement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendNonSolicitAgreement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCreditAuthorization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\SendCreditAuthorization $parameters
     * @return \eContract\StructType\SendCreditAuthorizationResponse|bool
     */
    public function SendCreditAuthorization(\eContract\StructType\SendCreditAuthorization $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendCreditAuthorization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eContract\StructType\SendCreditAuthorizationResponse|\eContract\StructType\SendNonSolicitAgreementResponse|\eContract\StructType\SendQuoteEmail2Response|\eContract\StructType\SendQuoteEmailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
