<?php

namespace eContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\GetContract $parameters
     * @return \eContract\StructType\GetContractResponse|bool
     */
    public function GetContract(\eContract\StructType\GetContract $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractAsPrimary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\GetContractAsPrimary $parameters
     * @return \eContract\StructType\GetContractAsPrimaryResponse|bool
     */
    public function GetContractAsPrimary(\eContract\StructType\GetContractAsPrimary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractAsPrimary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eContract\StructType\GetContractID $parameters
     * @return \eContract\StructType\GetContractIDResponse|bool
     */
    public function GetContractID(\eContract\StructType\GetContractID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eContract\StructType\GetContractAsPrimaryResponse|\eContract\StructType\GetContractIDResponse|\eContract\StructType\GetContractResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
