<?php

namespace eContract\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEquipmentItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEquipmentItem
 * @subpackage Arrays
 */
class ArrayOfEquipmentItem extends AbstractStructArrayBase
{
    /**
     * The EquipmentItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eContract\StructType\EquipmentItem[]
     */
    public $EquipmentItem;
    /**
     * Constructor method for ArrayOfEquipmentItem
     * @uses ArrayOfEquipmentItem::setEquipmentItem()
     * @param \eContract\StructType\EquipmentItem[] $equipmentItem
     */
    public function __construct(array $equipmentItem = array())
    {
        $this
            ->setEquipmentItem($equipmentItem);
    }
    /**
     * Get EquipmentItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eContract\StructType\EquipmentItem[]|null
     */
    public function getEquipmentItem()
    {
        return isset($this->EquipmentItem) ? $this->EquipmentItem : null;
    }
    /**
     * Set EquipmentItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eContract\StructType\EquipmentItem[] $equipmentItem
     * @return \eContract\ArrayType\ArrayOfEquipmentItem
     */
    public function setEquipmentItem(array $equipmentItem = array())
    {
        foreach ($equipmentItem as $arrayOfEquipmentItemEquipmentItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfEquipmentItemEquipmentItemItem instanceof \eContract\StructType\EquipmentItem) {
                throw new \InvalidArgumentException(sprintf('The EquipmentItem property can only contain items of \eContract\StructType\EquipmentItem, "%s" given', is_object($arrayOfEquipmentItemEquipmentItemItem) ? get_class($arrayOfEquipmentItemEquipmentItemItem) : gettype($arrayOfEquipmentItemEquipmentItemItem)), __LINE__);
            }
        }
        if (is_null($equipmentItem) || (is_array($equipmentItem) && empty($equipmentItem))) {
            unset($this->EquipmentItem);
        } else {
            $this->EquipmentItem = $equipmentItem;
        }
        return $this;
    }
    /**
     * Add item to EquipmentItem value
     * @throws \InvalidArgumentException
     * @param \eContract\StructType\EquipmentItem $item
     * @return \eContract\ArrayType\ArrayOfEquipmentItem
     */
    public function addToEquipmentItem(\eContract\StructType\EquipmentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eContract\StructType\EquipmentItem) {
            throw new \InvalidArgumentException(sprintf('The EquipmentItem property can only contain items of \eContract\StructType\EquipmentItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipmentItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eContract\StructType\EquipmentItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eContract\StructType\EquipmentItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eContract\StructType\EquipmentItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eContract\StructType\EquipmentItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eContract\StructType\EquipmentItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EquipmentItem
     */
    public function getAttributeName()
    {
        return 'EquipmentItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \eContract\ArrayType\ArrayOfEquipmentItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
