<?php

namespace MoniContract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateContractConsumerResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateContractConsumerResult
 * @subpackage Structs
 */
class CreateContractConsumerResult extends AbstractStructBase
{
    /**
     * The EnvelopeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvelopeID;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniContract\StructType\ErrorResponse
     */
    public $Errors;
    /**
     * The SigningURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniContract\ArrayType\ArrayOfstring_1
     */
    public $SigningURL;
    /**
     * Constructor method for CreateContractConsumerResult
     * @uses CreateContractConsumerResult::setEnvelopeID()
     * @uses CreateContractConsumerResult::setErrors()
     * @uses CreateContractConsumerResult::setSigningURL()
     * @param string $envelopeID
     * @param \MoniContract\StructType\ErrorResponse $errors
     * @param \MoniContract\ArrayType\ArrayOfstring_1 $signingURL
     */
    public function __construct($envelopeID = null, \MoniContract\StructType\ErrorResponse $errors = null, \MoniContract\ArrayType\ArrayOfstring_1 $signingURL = null)
    {
        $this
            ->setEnvelopeID($envelopeID)
            ->setErrors($errors)
            ->setSigningURL($signingURL);
    }
    /**
     * Get EnvelopeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvelopeID()
    {
        return isset($this->EnvelopeID) ? $this->EnvelopeID : null;
    }
    /**
     * Set EnvelopeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envelopeID
     * @return \MoniContract\StructType\CreateContractConsumerResult
     */
    public function setEnvelopeID($envelopeID = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeID) && !is_string($envelopeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envelopeID)), __LINE__);
        }
        if (is_null($envelopeID) || (is_array($envelopeID) && empty($envelopeID))) {
            unset($this->EnvelopeID);
        } else {
            $this->EnvelopeID = $envelopeID;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniContract\StructType\ErrorResponse|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \MoniContract\StructType\ErrorResponse $errors
     * @return \MoniContract\StructType\CreateContractConsumerResult
     */
    public function setErrors(\MoniContract\StructType\ErrorResponse $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get SigningURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniContract\ArrayType\ArrayOfstring_1|null
     */
    public function getSigningURL()
    {
        return isset($this->SigningURL) ? $this->SigningURL : null;
    }
    /**
     * Set SigningURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \MoniContract\ArrayType\ArrayOfstring_1 $signingURL
     * @return \MoniContract\StructType\CreateContractConsumerResult
     */
    public function setSigningURL(\MoniContract\ArrayType\ArrayOfstring_1 $signingURL = null)
    {
        if (is_null($signingURL) || (is_array($signingURL) && empty($signingURL))) {
            unset($this->SigningURL);
        } else {
            $this->SigningURL = $signingURL;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniContract\StructType\CreateContractConsumerResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
