<?php

namespace MoniContract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendQuoteEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SendQuoteEmail $parameters
     * @return \MoniContract\StructType\SendQuoteEmailResponse|bool
     */
    public function SendQuoteEmail(\MoniContract\StructType\SendQuoteEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendQuoteEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendQuoteEmail2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SendQuoteEmail2 $parameters
     * @return \MoniContract\StructType\SendQuoteEmail2Response|bool
     */
    public function SendQuoteEmail2(\MoniContract\StructType\SendQuoteEmail2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendQuoteEmail2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendNonSolicitAgreement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SendNonSolicitAgreement $parameters
     * @return \MoniContract\StructType\SendNonSolicitAgreementResponse|bool
     */
    public function SendNonSolicitAgreement(\MoniContract\StructType\SendNonSolicitAgreement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendNonSolicitAgreement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCreditAuthorization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SendCreditAuthorization $parameters
     * @return \MoniContract\StructType\SendCreditAuthorizationResponse|bool
     */
    public function SendCreditAuthorization(\MoniContract\StructType\SendCreditAuthorization $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendCreditAuthorization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCancelLetter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniContract\StructType\SendCancelLetter $parameters
     * @return \MoniContract\StructType\SendCancelLetterResponse|bool
     */
    public function SendCancelLetter(\MoniContract\StructType\SendCancelLetter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendCancelLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniContract\StructType\SendCancelLetterResponse|\MoniContract\StructType\SendCreditAuthorizationResponse|\MoniContract\StructType\SendNonSolicitAgreementResponse|\MoniContract\StructType\SendQuoteEmail2Response|\MoniContract\StructType\SendQuoteEmailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
