<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/invoice',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/invoice',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getCustomerPaymentTerms operation/method
 */
if ($get->getCustomerPaymentTerms($id, $credentials, $customerNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoiceBasic operation/method
 */
if ($get->getInvoiceBasic($customerNumber, $userCredential, $invoiceNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoicesByDivision operation/method
 */
if ($get->getInvoicesByDivision($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $division, $fromDate, $toDate) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoices operation/method
 */
if ($get->getInvoices($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $fromDate, $toDate) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoicesByInvoiceNumber operation/method
 */
if ($get->getInvoicesByInvoiceNumber($customerNumber, $userCredential, $invoiceNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoicesByOrderNumber operation/method
 */
if ($get->getInvoicesByOrderNumber($customerNumber, $userCredential, $orderNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoicesByPoNumber operation/method
 */
if ($get->getInvoicesByPoNumber($customerNumber, $userCredential, $poNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoicesByDate operation/method
 */
if ($get->getInvoicesByDate($customerNumber, $userCredential, $fromDate, $toDate) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInvoiceBasicFull operation/method
 */
if ($get->getInvoiceBasicFull($customerNumber, $userCredential, $invoiceNumber, $division, $offset, $limit, $field, $sortOrder) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
