<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceItem StructType
 * @subpackage Structs
 */
class InvoiceItem extends AbstractStructBase
{
    /**
     * The shippedQuantity
     * @var int
     */
    public $shippedQuantity;
    /**
     * The item
     * @var string
     */
    public $item;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The unitPrice
     * @var string
     */
    public $unitPrice;
    /**
     * The extAmount
     * @var string
     */
    public $extAmount;
    /**
     * The sequenceNumber
     * @var string
     */
    public $sequenceNumber;
    /**
     * Constructor method for InvoiceItem
     * @uses InvoiceItem::setShippedQuantity()
     * @uses InvoiceItem::setItem()
     * @uses InvoiceItem::setDescription()
     * @uses InvoiceItem::setUnitPrice()
     * @uses InvoiceItem::setExtAmount()
     * @uses InvoiceItem::setSequenceNumber()
     * @param int $shippedQuantity
     * @param string $item
     * @param string $description
     * @param string $unitPrice
     * @param string $extAmount
     * @param string $sequenceNumber
     */
    public function __construct($shippedQuantity = null, $item = null, $description = null, $unitPrice = null, $extAmount = null, $sequenceNumber = null)
    {
        $this
            ->setShippedQuantity($shippedQuantity)
            ->setItem($item)
            ->setDescription($description)
            ->setUnitPrice($unitPrice)
            ->setExtAmount($extAmount)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get shippedQuantity value
     * @return int|null
     */
    public function getShippedQuantity()
    {
        return $this->shippedQuantity;
    }
    /**
     * Set shippedQuantity value
     * @param int $shippedQuantity
     * @return \StructType\InvoiceItem
     */
    public function setShippedQuantity($shippedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($shippedQuantity) && !(is_int($shippedQuantity) || ctype_digit($shippedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippedQuantity, true), gettype($shippedQuantity)), __LINE__);
        }
        $this->shippedQuantity = $shippedQuantity;
        return $this;
    }
    /**
     * Get item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param string $item
     * @return \StructType\InvoiceItem
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\InvoiceItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param string $unitPrice
     * @return \StructType\InvoiceItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get extAmount value
     * @return string|null
     */
    public function getExtAmount()
    {
        return $this->extAmount;
    }
    /**
     * Set extAmount value
     * @param string $extAmount
     * @return \StructType\InvoiceItem
     */
    public function setExtAmount($extAmount = null)
    {
        // validation for constraint: string
        if (!is_null($extAmount) && !is_string($extAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extAmount, true), gettype($extAmount)), __LINE__);
        }
        $this->extAmount = $extAmount;
        return $this;
    }
    /**
     * Get sequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\InvoiceItem
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
