<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceBasicFullTotal StructType
 * @subpackage Structs
 */
class InvoiceBasicFullTotal extends AbstractStructBase
{
    /**
     * The invoiceBasicFull
     * Meta information extracted from the WSDL
     * - arrayType: tns:InvoiceBasicFull[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\InvoiceBasicFull[]
     */
    public $invoiceBasicFull;
    /**
     * The totalNumOfInvoices
     * @var int
     */
    public $totalNumOfInvoices;
    /**
     * Constructor method for InvoiceBasicFullTotal
     * @uses InvoiceBasicFullTotal::setInvoiceBasicFull()
     * @uses InvoiceBasicFullTotal::setTotalNumOfInvoices()
     * @param \StructType\InvoiceBasicFull[] $invoiceBasicFull
     * @param int $totalNumOfInvoices
     */
    public function __construct(array $invoiceBasicFull = array(), $totalNumOfInvoices = null)
    {
        $this
            ->setInvoiceBasicFull($invoiceBasicFull)
            ->setTotalNumOfInvoices($totalNumOfInvoices);
    }
    /**
     * Get invoiceBasicFull value
     * @return \StructType\InvoiceBasicFull[]|null
     */
    public function getInvoiceBasicFull()
    {
        return $this->invoiceBasicFull;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceBasicFull method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceBasicFull method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceBasicFullForArrayConstraintsFromSetInvoiceBasicFull(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceBasicFullTotalInvoiceBasicFullItem) {
            // validation for constraint: itemType
            if (!$invoiceBasicFullTotalInvoiceBasicFullItem instanceof \StructType\InvoiceBasicFull) {
                $invalidValues[] = is_object($invoiceBasicFullTotalInvoiceBasicFullItem) ? get_class($invoiceBasicFullTotalInvoiceBasicFullItem) : sprintf('%s(%s)', gettype($invoiceBasicFullTotalInvoiceBasicFullItem), var_export($invoiceBasicFullTotalInvoiceBasicFullItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invoiceBasicFull property can only contain items of type \StructType\InvoiceBasicFull, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invoiceBasicFull value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceBasicFull[] $invoiceBasicFull
     * @return \StructType\InvoiceBasicFullTotal
     */
    public function setInvoiceBasicFull(array $invoiceBasicFull = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceBasicFullArrayErrorMessage = self::validateInvoiceBasicFullForArrayConstraintsFromSetInvoiceBasicFull($invoiceBasicFull))) {
            throw new \InvalidArgumentException($invoiceBasicFullArrayErrorMessage, __LINE__);
        }
        $this->invoiceBasicFull = $invoiceBasicFull;
        return $this;
    }
    /**
     * Add item to invoiceBasicFull value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceBasicFull $item
     * @return \StructType\InvoiceBasicFullTotal
     */
    public function addToInvoiceBasicFull(\StructType\InvoiceBasicFull $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceBasicFull) {
            throw new \InvalidArgumentException(sprintf('The invoiceBasicFull property can only contain items of type \StructType\InvoiceBasicFull, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invoiceBasicFull[] = $item;
        return $this;
    }
    /**
     * Get totalNumOfInvoices value
     * @return int|null
     */
    public function getTotalNumOfInvoices()
    {
        return $this->totalNumOfInvoices;
    }
    /**
     * Set totalNumOfInvoices value
     * @param int $totalNumOfInvoices
     * @return \StructType\InvoiceBasicFullTotal
     */
    public function setTotalNumOfInvoices($totalNumOfInvoices = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumOfInvoices) && !(is_int($totalNumOfInvoices) || ctype_digit($totalNumOfInvoices))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumOfInvoices, true), gettype($totalNumOfInvoices)), __LINE__);
        }
        $this->totalNumOfInvoices = $totalNumOfInvoices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceBasicFullTotal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
