<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceBasicFull StructType
 * @subpackage Structs
 */
class InvoiceBasicFull extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The total
     * @var string
     */
    public $total;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The poNumber
     * @var string
     */
    public $poNumber;
    /**
     * The invoiceDate
     * @var string
     */
    public $invoiceDate;
    /**
     * The invoiceType
     * @var string
     */
    public $invoiceType;
    /**
     * The division
     * @var string
     */
    public $division;
    /**
     * The applied
     * @var string
     */
    public $applied;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for InvoiceBasicFull
     * @uses InvoiceBasicFull::setNumber()
     * @uses InvoiceBasicFull::setTotal()
     * @uses InvoiceBasicFull::setOrderNumber()
     * @uses InvoiceBasicFull::setPoNumber()
     * @uses InvoiceBasicFull::setInvoiceDate()
     * @uses InvoiceBasicFull::setInvoiceType()
     * @uses InvoiceBasicFull::setDivision()
     * @uses InvoiceBasicFull::setApplied()
     * @uses InvoiceBasicFull::setStatus()
     * @param string $number
     * @param string $total
     * @param string $orderNumber
     * @param string $poNumber
     * @param string $invoiceDate
     * @param string $invoiceType
     * @param string $division
     * @param string $applied
     * @param string $status
     */
    public function __construct($number = null, $total = null, $orderNumber = null, $poNumber = null, $invoiceDate = null, $invoiceType = null, $division = null, $applied = null, $status = null)
    {
        $this
            ->setNumber($number)
            ->setTotal($total)
            ->setOrderNumber($orderNumber)
            ->setPoNumber($poNumber)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceType($invoiceType)
            ->setDivision($division)
            ->setApplied($applied)
            ->setStatus($status);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\InvoiceBasicFull
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get total value
     * @return string|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param string $total
     * @return \StructType\InvoiceBasicFull
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\InvoiceBasicFull
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get poNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
    /**
     * Set poNumber value
     * @param string $poNumber
     * @return \StructType\InvoiceBasicFull
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->poNumber = $poNumber;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \StructType\InvoiceBasicFull
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get invoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->invoiceType;
    }
    /**
     * Set invoiceType value
     * @param string $invoiceType
     * @return \StructType\InvoiceBasicFull
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceType) && !is_string($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->invoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get division value
     * @return string|null
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * Set division value
     * @param string $division
     * @return \StructType\InvoiceBasicFull
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        $this->division = $division;
        return $this;
    }
    /**
     * Get applied value
     * @return string|null
     */
    public function getApplied()
    {
        return $this->applied;
    }
    /**
     * Set applied value
     * @param string $applied
     * @return \StructType\InvoiceBasicFull
     */
    public function setApplied($applied = null)
    {
        // validation for constraint: string
        if (!is_null($applied) && !is_string($applied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applied, true), gettype($applied)), __LINE__);
        }
        $this->applied = $applied;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\InvoiceBasicFull
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceBasicFull
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
