<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The orderSuffix
     * @var string
     */
    public $orderSuffix;
    /**
     * The poNumber
     * @var string
     */
    public $poNumber;
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The customerName
     * @var string
     */
    public $customerName;
    /**
     * The invoiceDate
     * @var string
     */
    public $invoiceDate;
    /**
     * The terms
     * @var string
     */
    public $terms;
    /**
     * The mailToName
     * @var string
     */
    public $mailToName;
    /**
     * The mailToAddress1
     * @var string
     */
    public $mailToAddress1;
    /**
     * The mailToAddress2
     * @var string
     */
    public $mailToAddress2;
    /**
     * The mailToAddress3
     * @var string
     */
    public $mailToAddress3;
    /**
     * The mailToCity
     * @var string
     */
    public $mailToCity;
    /**
     * The mailToState
     * @var string
     */
    public $mailToState;
    /**
     * The mailToCountry
     * @var string
     */
    public $mailToCountry;
    /**
     * The mailToZip
     * @var string
     */
    public $mailToZip;
    /**
     * The mailToCarrier
     * @var string
     */
    public $mailToCarrier;
    /**
     * The subtotal
     * @var string
     */
    public $subtotal;
    /**
     * The appliedAmount
     * @var string
     */
    public $appliedAmount;
    /**
     * The freight
     * @var string
     */
    public $freight;
    /**
     * The tax
     * @var string
     */
    public $tax;
    /**
     * The total
     * @var string
     */
    public $total;
    /**
     * The exchangeRate
     * @var float
     */
    public $exchangeRate;
    /**
     * The shipToName
     * @var string
     */
    public $shipToName;
    /**
     * The shipToAddress1
     * @var string
     */
    public $shipToAddress1;
    /**
     * The shipToAddress2
     * @var string
     */
    public $shipToAddress2;
    /**
     * The shipToAddress3
     * @var string
     */
    public $shipToAddress3;
    /**
     * The shipToCityStateZip
     * @var string
     */
    public $shipToCityStateZip;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The division
     * @var string
     */
    public $division;
    /**
     * The items
     * Meta information extracted from the WSDL
     * - arrayType: tns:InvoiceItem[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\InvoiceItem[]
     */
    public $items;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setNumber()
     * @uses Invoice::setOrderNumber()
     * @uses Invoice::setOrderSuffix()
     * @uses Invoice::setPoNumber()
     * @uses Invoice::setCustomerNumber()
     * @uses Invoice::setCustomerName()
     * @uses Invoice::setInvoiceDate()
     * @uses Invoice::setTerms()
     * @uses Invoice::setMailToName()
     * @uses Invoice::setMailToAddress1()
     * @uses Invoice::setMailToAddress2()
     * @uses Invoice::setMailToAddress3()
     * @uses Invoice::setMailToCity()
     * @uses Invoice::setMailToState()
     * @uses Invoice::setMailToCountry()
     * @uses Invoice::setMailToZip()
     * @uses Invoice::setMailToCarrier()
     * @uses Invoice::setSubtotal()
     * @uses Invoice::setAppliedAmount()
     * @uses Invoice::setFreight()
     * @uses Invoice::setTax()
     * @uses Invoice::setTotal()
     * @uses Invoice::setExchangeRate()
     * @uses Invoice::setShipToName()
     * @uses Invoice::setShipToAddress1()
     * @uses Invoice::setShipToAddress2()
     * @uses Invoice::setShipToAddress3()
     * @uses Invoice::setShipToCityStateZip()
     * @uses Invoice::setStatus()
     * @uses Invoice::setType()
     * @uses Invoice::setDivision()
     * @uses Invoice::setItems()
     * @param string $number
     * @param string $orderNumber
     * @param string $orderSuffix
     * @param string $poNumber
     * @param string $customerNumber
     * @param string $customerName
     * @param string $invoiceDate
     * @param string $terms
     * @param string $mailToName
     * @param string $mailToAddress1
     * @param string $mailToAddress2
     * @param string $mailToAddress3
     * @param string $mailToCity
     * @param string $mailToState
     * @param string $mailToCountry
     * @param string $mailToZip
     * @param string $mailToCarrier
     * @param string $subtotal
     * @param string $appliedAmount
     * @param string $freight
     * @param string $tax
     * @param string $total
     * @param float $exchangeRate
     * @param string $shipToName
     * @param string $shipToAddress1
     * @param string $shipToAddress2
     * @param string $shipToAddress3
     * @param string $shipToCityStateZip
     * @param string $status
     * @param string $type
     * @param string $division
     * @param \StructType\InvoiceItem[] $items
     */
    public function __construct($number = null, $orderNumber = null, $orderSuffix = null, $poNumber = null, $customerNumber = null, $customerName = null, $invoiceDate = null, $terms = null, $mailToName = null, $mailToAddress1 = null, $mailToAddress2 = null, $mailToAddress3 = null, $mailToCity = null, $mailToState = null, $mailToCountry = null, $mailToZip = null, $mailToCarrier = null, $subtotal = null, $appliedAmount = null, $freight = null, $tax = null, $total = null, $exchangeRate = null, $shipToName = null, $shipToAddress1 = null, $shipToAddress2 = null, $shipToAddress3 = null, $shipToCityStateZip = null, $status = null, $type = null, $division = null, array $items = array())
    {
        $this
            ->setNumber($number)
            ->setOrderNumber($orderNumber)
            ->setOrderSuffix($orderSuffix)
            ->setPoNumber($poNumber)
            ->setCustomerNumber($customerNumber)
            ->setCustomerName($customerName)
            ->setInvoiceDate($invoiceDate)
            ->setTerms($terms)
            ->setMailToName($mailToName)
            ->setMailToAddress1($mailToAddress1)
            ->setMailToAddress2($mailToAddress2)
            ->setMailToAddress3($mailToAddress3)
            ->setMailToCity($mailToCity)
            ->setMailToState($mailToState)
            ->setMailToCountry($mailToCountry)
            ->setMailToZip($mailToZip)
            ->setMailToCarrier($mailToCarrier)
            ->setSubtotal($subtotal)
            ->setAppliedAmount($appliedAmount)
            ->setFreight($freight)
            ->setTax($tax)
            ->setTotal($total)
            ->setExchangeRate($exchangeRate)
            ->setShipToName($shipToName)
            ->setShipToAddress1($shipToAddress1)
            ->setShipToAddress2($shipToAddress2)
            ->setShipToAddress3($shipToAddress3)
            ->setShipToCityStateZip($shipToCityStateZip)
            ->setStatus($status)
            ->setType($type)
            ->setDivision($division)
            ->setItems($items);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Invoice
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Invoice
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderSuffix value
     * @return string|null
     */
    public function getOrderSuffix()
    {
        return $this->orderSuffix;
    }
    /**
     * Set orderSuffix value
     * @param string $orderSuffix
     * @return \StructType\Invoice
     */
    public function setOrderSuffix($orderSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($orderSuffix) && !is_string($orderSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderSuffix, true), gettype($orderSuffix)), __LINE__);
        }
        $this->orderSuffix = $orderSuffix;
        return $this;
    }
    /**
     * Get poNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
    /**
     * Set poNumber value
     * @param string $poNumber
     * @return \StructType\Invoice
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->poNumber = $poNumber;
        return $this;
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\Invoice
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get customerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->customerName;
    }
    /**
     * Set customerName value
     * @param string $customerName
     * @return \StructType\Invoice
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->customerName = $customerName;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Invoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get terms value
     * @return string|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param string $terms
     * @return \StructType\Invoice
     */
    public function setTerms($terms = null)
    {
        // validation for constraint: string
        if (!is_null($terms) && !is_string($terms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terms, true), gettype($terms)), __LINE__);
        }
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get mailToName value
     * @return string|null
     */
    public function getMailToName()
    {
        return $this->mailToName;
    }
    /**
     * Set mailToName value
     * @param string $mailToName
     * @return \StructType\Invoice
     */
    public function setMailToName($mailToName = null)
    {
        // validation for constraint: string
        if (!is_null($mailToName) && !is_string($mailToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToName, true), gettype($mailToName)), __LINE__);
        }
        $this->mailToName = $mailToName;
        return $this;
    }
    /**
     * Get mailToAddress1 value
     * @return string|null
     */
    public function getMailToAddress1()
    {
        return $this->mailToAddress1;
    }
    /**
     * Set mailToAddress1 value
     * @param string $mailToAddress1
     * @return \StructType\Invoice
     */
    public function setMailToAddress1($mailToAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($mailToAddress1) && !is_string($mailToAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToAddress1, true), gettype($mailToAddress1)), __LINE__);
        }
        $this->mailToAddress1 = $mailToAddress1;
        return $this;
    }
    /**
     * Get mailToAddress2 value
     * @return string|null
     */
    public function getMailToAddress2()
    {
        return $this->mailToAddress2;
    }
    /**
     * Set mailToAddress2 value
     * @param string $mailToAddress2
     * @return \StructType\Invoice
     */
    public function setMailToAddress2($mailToAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($mailToAddress2) && !is_string($mailToAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToAddress2, true), gettype($mailToAddress2)), __LINE__);
        }
        $this->mailToAddress2 = $mailToAddress2;
        return $this;
    }
    /**
     * Get mailToAddress3 value
     * @return string|null
     */
    public function getMailToAddress3()
    {
        return $this->mailToAddress3;
    }
    /**
     * Set mailToAddress3 value
     * @param string $mailToAddress3
     * @return \StructType\Invoice
     */
    public function setMailToAddress3($mailToAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($mailToAddress3) && !is_string($mailToAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToAddress3, true), gettype($mailToAddress3)), __LINE__);
        }
        $this->mailToAddress3 = $mailToAddress3;
        return $this;
    }
    /**
     * Get mailToCity value
     * @return string|null
     */
    public function getMailToCity()
    {
        return $this->mailToCity;
    }
    /**
     * Set mailToCity value
     * @param string $mailToCity
     * @return \StructType\Invoice
     */
    public function setMailToCity($mailToCity = null)
    {
        // validation for constraint: string
        if (!is_null($mailToCity) && !is_string($mailToCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToCity, true), gettype($mailToCity)), __LINE__);
        }
        $this->mailToCity = $mailToCity;
        return $this;
    }
    /**
     * Get mailToState value
     * @return string|null
     */
    public function getMailToState()
    {
        return $this->mailToState;
    }
    /**
     * Set mailToState value
     * @param string $mailToState
     * @return \StructType\Invoice
     */
    public function setMailToState($mailToState = null)
    {
        // validation for constraint: string
        if (!is_null($mailToState) && !is_string($mailToState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToState, true), gettype($mailToState)), __LINE__);
        }
        $this->mailToState = $mailToState;
        return $this;
    }
    /**
     * Get mailToCountry value
     * @return string|null
     */
    public function getMailToCountry()
    {
        return $this->mailToCountry;
    }
    /**
     * Set mailToCountry value
     * @param string $mailToCountry
     * @return \StructType\Invoice
     */
    public function setMailToCountry($mailToCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mailToCountry) && !is_string($mailToCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToCountry, true), gettype($mailToCountry)), __LINE__);
        }
        $this->mailToCountry = $mailToCountry;
        return $this;
    }
    /**
     * Get mailToZip value
     * @return string|null
     */
    public function getMailToZip()
    {
        return $this->mailToZip;
    }
    /**
     * Set mailToZip value
     * @param string $mailToZip
     * @return \StructType\Invoice
     */
    public function setMailToZip($mailToZip = null)
    {
        // validation for constraint: string
        if (!is_null($mailToZip) && !is_string($mailToZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToZip, true), gettype($mailToZip)), __LINE__);
        }
        $this->mailToZip = $mailToZip;
        return $this;
    }
    /**
     * Get mailToCarrier value
     * @return string|null
     */
    public function getMailToCarrier()
    {
        return $this->mailToCarrier;
    }
    /**
     * Set mailToCarrier value
     * @param string $mailToCarrier
     * @return \StructType\Invoice
     */
    public function setMailToCarrier($mailToCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($mailToCarrier) && !is_string($mailToCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailToCarrier, true), gettype($mailToCarrier)), __LINE__);
        }
        $this->mailToCarrier = $mailToCarrier;
        return $this;
    }
    /**
     * Get subtotal value
     * @return string|null
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }
    /**
     * Set subtotal value
     * @param string $subtotal
     * @return \StructType\Invoice
     */
    public function setSubtotal($subtotal = null)
    {
        // validation for constraint: string
        if (!is_null($subtotal) && !is_string($subtotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtotal, true), gettype($subtotal)), __LINE__);
        }
        $this->subtotal = $subtotal;
        return $this;
    }
    /**
     * Get appliedAmount value
     * @return string|null
     */
    public function getAppliedAmount()
    {
        return $this->appliedAmount;
    }
    /**
     * Set appliedAmount value
     * @param string $appliedAmount
     * @return \StructType\Invoice
     */
    public function setAppliedAmount($appliedAmount = null)
    {
        // validation for constraint: string
        if (!is_null($appliedAmount) && !is_string($appliedAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appliedAmount, true), gettype($appliedAmount)), __LINE__);
        }
        $this->appliedAmount = $appliedAmount;
        return $this;
    }
    /**
     * Get freight value
     * @return string|null
     */
    public function getFreight()
    {
        return $this->freight;
    }
    /**
     * Set freight value
     * @param string $freight
     * @return \StructType\Invoice
     */
    public function setFreight($freight = null)
    {
        // validation for constraint: string
        if (!is_null($freight) && !is_string($freight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freight, true), gettype($freight)), __LINE__);
        }
        $this->freight = $freight;
        return $this;
    }
    /**
     * Get tax value
     * @return string|null
     */
    public function getTax()
    {
        return $this->tax;
    }
    /**
     * Set tax value
     * @param string $tax
     * @return \StructType\Invoice
     */
    public function setTax($tax = null)
    {
        // validation for constraint: string
        if (!is_null($tax) && !is_string($tax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->tax = $tax;
        return $this;
    }
    /**
     * Get total value
     * @return string|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param string $total
     * @return \StructType\Invoice
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Invoice
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get shipToName value
     * @return string|null
     */
    public function getShipToName()
    {
        return $this->shipToName;
    }
    /**
     * Set shipToName value
     * @param string $shipToName
     * @return \StructType\Invoice
     */
    public function setShipToName($shipToName = null)
    {
        // validation for constraint: string
        if (!is_null($shipToName) && !is_string($shipToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipToName, true), gettype($shipToName)), __LINE__);
        }
        $this->shipToName = $shipToName;
        return $this;
    }
    /**
     * Get shipToAddress1 value
     * @return string|null
     */
    public function getShipToAddress1()
    {
        return $this->shipToAddress1;
    }
    /**
     * Set shipToAddress1 value
     * @param string $shipToAddress1
     * @return \StructType\Invoice
     */
    public function setShipToAddress1($shipToAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($shipToAddress1) && !is_string($shipToAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipToAddress1, true), gettype($shipToAddress1)), __LINE__);
        }
        $this->shipToAddress1 = $shipToAddress1;
        return $this;
    }
    /**
     * Get shipToAddress2 value
     * @return string|null
     */
    public function getShipToAddress2()
    {
        return $this->shipToAddress2;
    }
    /**
     * Set shipToAddress2 value
     * @param string $shipToAddress2
     * @return \StructType\Invoice
     */
    public function setShipToAddress2($shipToAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($shipToAddress2) && !is_string($shipToAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipToAddress2, true), gettype($shipToAddress2)), __LINE__);
        }
        $this->shipToAddress2 = $shipToAddress2;
        return $this;
    }
    /**
     * Get shipToAddress3 value
     * @return string|null
     */
    public function getShipToAddress3()
    {
        return $this->shipToAddress3;
    }
    /**
     * Set shipToAddress3 value
     * @param string $shipToAddress3
     * @return \StructType\Invoice
     */
    public function setShipToAddress3($shipToAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($shipToAddress3) && !is_string($shipToAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipToAddress3, true), gettype($shipToAddress3)), __LINE__);
        }
        $this->shipToAddress3 = $shipToAddress3;
        return $this;
    }
    /**
     * Get shipToCityStateZip value
     * @return string|null
     */
    public function getShipToCityStateZip()
    {
        return $this->shipToCityStateZip;
    }
    /**
     * Set shipToCityStateZip value
     * @param string $shipToCityStateZip
     * @return \StructType\Invoice
     */
    public function setShipToCityStateZip($shipToCityStateZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipToCityStateZip) && !is_string($shipToCityStateZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipToCityStateZip, true), gettype($shipToCityStateZip)), __LINE__);
        }
        $this->shipToCityStateZip = $shipToCityStateZip;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Invoice
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Invoice
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get division value
     * @return string|null
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * Set division value
     * @param string $division
     * @return \StructType\Invoice
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        $this->division = $division;
        return $this;
    }
    /**
     * Get items value
     * @return \StructType\InvoiceItem[]|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceItemsItem) {
            // validation for constraint: itemType
            if (!$invoiceItemsItem instanceof \StructType\InvoiceItem) {
                $invalidValues[] = is_object($invoiceItemsItem) ? get_class($invoiceItemsItem) : sprintf('%s(%s)', gettype($invoiceItemsItem), var_export($invoiceItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \StructType\InvoiceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceItem[] $items
     * @return \StructType\Invoice
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceItem $item
     * @return \StructType\Invoice
     */
    public function addToItems(\StructType\InvoiceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceItem) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \StructType\InvoiceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
