<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCustomerPaymentTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $credentials
     * @param string $customerNumber
     * @return string|bool
     */
    public function getCustomerPaymentTerms($id, $credentials, $customerNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomerPaymentTerms($id, $credentials, $customerNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceBasic
     * Meta information extracted from the WSDL
     * - documentation: Gets basic invoice information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $invoiceNumber
     * @return \StructType\InvoiceBasic[]|bool
     */
    public function getInvoiceBasic($customerNumber, $userCredential, $invoiceNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceBasic($customerNumber, $userCredential, $invoiceNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoicesByDivision
     * Meta information extracted from the WSDL
     * - documentation: Gets invoices with division filter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $invoiceNumber
     * @param string $orderNumber
     * @param string $poNumber
     * @param string $division
     * @param string $fromDate
     * @param string $toDate
     * @return \StructType\InvoiceDivision[]|bool
     */
    public function getInvoicesByDivision($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $division, $fromDate, $toDate)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoicesByDivision($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $division, $fromDate, $toDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoices
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $invoiceNumber
     * @param string $orderNumber
     * @param string $poNumber
     * @param string $fromDate
     * @param string $toDate
     * @return \StructType\Invoice[]|bool
     */
    public function getInvoices($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $fromDate, $toDate)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoices($customerNumber, $userCredential, $invoiceNumber, $orderNumber, $poNumber, $fromDate, $toDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoicesByInvoiceNumber
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data given an invoice number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $invoiceNumber
     * @return \StructType\Invoice[]|bool
     */
    public function getInvoicesByInvoiceNumber($customerNumber, $userCredential, $invoiceNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoicesByInvoiceNumber($customerNumber, $userCredential, $invoiceNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoicesByOrderNumber
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data given an order number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $orderNumber
     * @return \StructType\Invoice[]|bool
     */
    public function getInvoicesByOrderNumber($customerNumber, $userCredential, $orderNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoicesByOrderNumber($customerNumber, $userCredential, $orderNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoicesByPoNumber
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data given a PO number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $poNumber
     * @return \StructType\Invoice[]|bool
     */
    public function getInvoicesByPoNumber($customerNumber, $userCredential, $poNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoicesByPoNumber($customerNumber, $userCredential, $poNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoicesByDate
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data given a date or date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $fromDate
     * @param string $toDate
     * @return \StructType\Invoice[]|bool
     */
    public function getInvoicesByDate($customerNumber, $userCredential, $fromDate, $toDate)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoicesByDate($customerNumber, $userCredential, $fromDate, $toDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInvoiceBasicFull
     * Meta information extracted from the WSDL
     * - documentation: Gets basic invoice information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $invoiceNumber
     * @param string $division
     * @param string $offset
     * @param string $limit
     * @param string $field
     * @param string $sortOrder
     * @return \StructType\InvoiceBasicFullTotal|bool
     */
    public function getInvoiceBasicFull($customerNumber, $userCredential, $invoiceNumber, $division, $offset, $limit, $field, $sortOrder)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoiceBasicFull($customerNumber, $userCredential, $invoiceNumber, $division, $offset, $limit, $field, $sortOrder));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\InvoiceBasicFullTotal|\StructType\InvoiceBasic[]|\StructType\InvoiceDivision[]|\StructType\Invoice[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
