<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/inventory',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/inventory',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getLevels operation/method
 */
if ($get->getLevels($customerNumber, $userCredential, $productNumber, $includeOutlet, $includeCompanionPart) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsWh30 operation/method
 */
if ($get->getLevelsWh30($customerNumber, $userCredential, $productNumber, $partNumber, $useCache) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsBlowout operation/method
 */
if ($get->getLevelsBlowout($customerNumber, $userCredential, $productNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsOutlet operation/method
 */
if ($get->getLevelsOutlet($customerNumber, $userCredential, $productNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Reserve ServiceType
 */
$reserve = new \ServiceType\Reserve($options);
/**
 * Sample call for reserveStock operation/method
 */
if ($reserve->reserveStock($customerNumber, $userCredential, $productNumber, $holdQuantity, $requiredDate, $holdTime) !== false) {
    print_r($reserve->getResult());
} else {
    print_r($reserve->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeInventoryHold operation/method
 */
if ($remove->removeInventoryHold($customerNumber, $userCredential, $holdId) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
