<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReserveStockResponse StructType
 * @subpackage Structs
 */
class ReserveStockResponse extends AbstractStructBase
{
    /**
     * The holdId
     * @var string
     */
    public $holdId;
    /**
     * The holdValid
     * @var string
     */
    public $holdValid;
    /**
     * The holdTill
     * @var string
     */
    public $holdTill;
    /**
     * The rawMaterial
     * @var string
     */
    public $rawMaterial;
    /**
     * The erpMessage
     * @var string
     */
    public $erpMessage;
    /**
     * Constructor method for ReserveStockResponse
     * @uses ReserveStockResponse::setHoldId()
     * @uses ReserveStockResponse::setHoldValid()
     * @uses ReserveStockResponse::setHoldTill()
     * @uses ReserveStockResponse::setRawMaterial()
     * @uses ReserveStockResponse::setErpMessage()
     * @param string $holdId
     * @param string $holdValid
     * @param string $holdTill
     * @param string $rawMaterial
     * @param string $erpMessage
     */
    public function __construct($holdId = null, $holdValid = null, $holdTill = null, $rawMaterial = null, $erpMessage = null)
    {
        $this
            ->setHoldId($holdId)
            ->setHoldValid($holdValid)
            ->setHoldTill($holdTill)
            ->setRawMaterial($rawMaterial)
            ->setErpMessage($erpMessage);
    }
    /**
     * Get holdId value
     * @return string|null
     */
    public function getHoldId()
    {
        return $this->holdId;
    }
    /**
     * Set holdId value
     * @param string $holdId
     * @return \StructType\ReserveStockResponse
     */
    public function setHoldId($holdId = null)
    {
        // validation for constraint: string
        if (!is_null($holdId) && !is_string($holdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdId, true), gettype($holdId)), __LINE__);
        }
        $this->holdId = $holdId;
        return $this;
    }
    /**
     * Get holdValid value
     * @return string|null
     */
    public function getHoldValid()
    {
        return $this->holdValid;
    }
    /**
     * Set holdValid value
     * @param string $holdValid
     * @return \StructType\ReserveStockResponse
     */
    public function setHoldValid($holdValid = null)
    {
        // validation for constraint: string
        if (!is_null($holdValid) && !is_string($holdValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdValid, true), gettype($holdValid)), __LINE__);
        }
        $this->holdValid = $holdValid;
        return $this;
    }
    /**
     * Get holdTill value
     * @return string|null
     */
    public function getHoldTill()
    {
        return $this->holdTill;
    }
    /**
     * Set holdTill value
     * @param string $holdTill
     * @return \StructType\ReserveStockResponse
     */
    public function setHoldTill($holdTill = null)
    {
        // validation for constraint: string
        if (!is_null($holdTill) && !is_string($holdTill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdTill, true), gettype($holdTill)), __LINE__);
        }
        $this->holdTill = $holdTill;
        return $this;
    }
    /**
     * Get rawMaterial value
     * @return string|null
     */
    public function getRawMaterial()
    {
        return $this->rawMaterial;
    }
    /**
     * Set rawMaterial value
     * @param string $rawMaterial
     * @return \StructType\ReserveStockResponse
     */
    public function setRawMaterial($rawMaterial = null)
    {
        // validation for constraint: string
        if (!is_null($rawMaterial) && !is_string($rawMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rawMaterial, true), gettype($rawMaterial)), __LINE__);
        }
        $this->rawMaterial = $rawMaterial;
        return $this;
    }
    /**
     * Get erpMessage value
     * @return string|null
     */
    public function getErpMessage()
    {
        return $this->erpMessage;
    }
    /**
     * Set erpMessage value
     * @param string $erpMessage
     * @return \StructType\ReserveStockResponse
     */
    public function setErpMessage($erpMessage = null)
    {
        // validation for constraint: string
        if (!is_null($erpMessage) && !is_string($erpMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpMessage, true), gettype($erpMessage)), __LINE__);
        }
        $this->erpMessage = $erpMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReserveStockResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
