<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductColorInventory StructType
 * @subpackage Structs
 */
class ProductColorInventory extends AbstractStructBase
{
    /**
     * The part_number
     * @var string
     */
    public $part_number;
    /**
     * The quantity_available
     * @var string
     */
    public $quantity_available;
    /**
     * The color
     * @var string
     */
    public $color;
    /**
     * Constructor method for ProductColorInventory
     * @uses ProductColorInventory::setPart_number()
     * @uses ProductColorInventory::setQuantity_available()
     * @uses ProductColorInventory::setColor()
     * @param string $part_number
     * @param string $quantity_available
     * @param string $color
     */
    public function __construct($part_number = null, $quantity_available = null, $color = null)
    {
        $this
            ->setPart_number($part_number)
            ->setQuantity_available($quantity_available)
            ->setColor($color);
    }
    /**
     * Get part_number value
     * @return string|null
     */
    public function getPart_number()
    {
        return $this->part_number;
    }
    /**
     * Set part_number value
     * @param string $part_number
     * @return \StructType\ProductColorInventory
     */
    public function setPart_number($part_number = null)
    {
        // validation for constraint: string
        if (!is_null($part_number) && !is_string($part_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($part_number, true), gettype($part_number)), __LINE__);
        }
        $this->part_number = $part_number;
        return $this;
    }
    /**
     * Get quantity_available value
     * @return string|null
     */
    public function getQuantity_available()
    {
        return $this->quantity_available;
    }
    /**
     * Set quantity_available value
     * @param string $quantity_available
     * @return \StructType\ProductColorInventory
     */
    public function setQuantity_available($quantity_available = null)
    {
        // validation for constraint: string
        if (!is_null($quantity_available) && !is_string($quantity_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity_available, true), gettype($quantity_available)), __LINE__);
        }
        $this->quantity_available = $quantity_available;
        return $this;
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \StructType\ProductColorInventory
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductColorInventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
