<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryLevels StructType
 * @subpackage Structs
 */
class InventoryLevels extends AbstractStructBase
{
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The productColorInventories
     * Meta information extracted from the WSDL
     * - arrayType: tns:ProductColorInventory[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ProductColorInventory[]
     */
    public $productColorInventories;
    /**
     * The companionProductInventoryLevels
     * Meta information extracted from the WSDL
     * - arrayType: tns:CompanionProductInventoryLevels[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\CompanionProductInventoryLevels[]
     */
    public $companionProductInventoryLevels;
    /**
     * Constructor method for InventoryLevels
     * @uses InventoryLevels::setProductNumber()
     * @uses InventoryLevels::setProductColorInventories()
     * @uses InventoryLevels::setCompanionProductInventoryLevels()
     * @param string $productNumber
     * @param \StructType\ProductColorInventory[] $productColorInventories
     * @param \StructType\CompanionProductInventoryLevels[] $companionProductInventoryLevels
     */
    public function __construct($productNumber = null, array $productColorInventories = array(), array $companionProductInventoryLevels = array())
    {
        $this
            ->setProductNumber($productNumber)
            ->setProductColorInventories($productColorInventories)
            ->setCompanionProductInventoryLevels($companionProductInventoryLevels);
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\InventoryLevels
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get productColorInventories value
     * @return \StructType\ProductColorInventory[]|null
     */
    public function getProductColorInventories()
    {
        return $this->productColorInventories;
    }
    /**
     * This method is responsible for validating the values passed to the setProductColorInventories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductColorInventories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductColorInventoriesForArrayConstraintsFromSetProductColorInventories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryLevelsProductColorInventoriesItem) {
            // validation for constraint: itemType
            if (!$inventoryLevelsProductColorInventoriesItem instanceof \StructType\ProductColorInventory) {
                $invalidValues[] = is_object($inventoryLevelsProductColorInventoriesItem) ? get_class($inventoryLevelsProductColorInventoriesItem) : sprintf('%s(%s)', gettype($inventoryLevelsProductColorInventoriesItem), var_export($inventoryLevelsProductColorInventoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productColorInventories property can only contain items of type \StructType\ProductColorInventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productColorInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductColorInventory[] $productColorInventories
     * @return \StructType\InventoryLevels
     */
    public function setProductColorInventories(array $productColorInventories = array())
    {
        // validation for constraint: array
        if ('' !== ($productColorInventoriesArrayErrorMessage = self::validateProductColorInventoriesForArrayConstraintsFromSetProductColorInventories($productColorInventories))) {
            throw new \InvalidArgumentException($productColorInventoriesArrayErrorMessage, __LINE__);
        }
        $this->productColorInventories = $productColorInventories;
        return $this;
    }
    /**
     * Add item to productColorInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductColorInventory $item
     * @return \StructType\InventoryLevels
     */
    public function addToProductColorInventories(\StructType\ProductColorInventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductColorInventory) {
            throw new \InvalidArgumentException(sprintf('The productColorInventories property can only contain items of type \StructType\ProductColorInventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productColorInventories[] = $item;
        return $this;
    }
    /**
     * Get companionProductInventoryLevels value
     * @return \StructType\CompanionProductInventoryLevels[]|null
     */
    public function getCompanionProductInventoryLevels()
    {
        return $this->companionProductInventoryLevels;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanionProductInventoryLevels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanionProductInventoryLevels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanionProductInventoryLevelsForArrayConstraintsFromSetCompanionProductInventoryLevels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventoryLevelsCompanionProductInventoryLevelsItem) {
            // validation for constraint: itemType
            if (!$inventoryLevelsCompanionProductInventoryLevelsItem instanceof \StructType\CompanionProductInventoryLevels) {
                $invalidValues[] = is_object($inventoryLevelsCompanionProductInventoryLevelsItem) ? get_class($inventoryLevelsCompanionProductInventoryLevelsItem) : sprintf('%s(%s)', gettype($inventoryLevelsCompanionProductInventoryLevelsItem), var_export($inventoryLevelsCompanionProductInventoryLevelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The companionProductInventoryLevels property can only contain items of type \StructType\CompanionProductInventoryLevels, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set companionProductInventoryLevels value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanionProductInventoryLevels[] $companionProductInventoryLevels
     * @return \StructType\InventoryLevels
     */
    public function setCompanionProductInventoryLevels(array $companionProductInventoryLevels = array())
    {
        // validation for constraint: array
        if ('' !== ($companionProductInventoryLevelsArrayErrorMessage = self::validateCompanionProductInventoryLevelsForArrayConstraintsFromSetCompanionProductInventoryLevels($companionProductInventoryLevels))) {
            throw new \InvalidArgumentException($companionProductInventoryLevelsArrayErrorMessage, __LINE__);
        }
        $this->companionProductInventoryLevels = $companionProductInventoryLevels;
        return $this;
    }
    /**
     * Add item to companionProductInventoryLevels value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanionProductInventoryLevels $item
     * @return \StructType\InventoryLevels
     */
    public function addToCompanionProductInventoryLevels(\StructType\CompanionProductInventoryLevels $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanionProductInventoryLevels) {
            throw new \InvalidArgumentException(sprintf('The companionProductInventoryLevels property can only contain items of type \StructType\CompanionProductInventoryLevels, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->companionProductInventoryLevels[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryLevels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
