<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reserve ServiceType
 * @subpackage Services
 */
class Reserve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reserveStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $holdQuantity
     * @param string $requiredDate
     * @param string $holdTime
     * @return \StructType\ReserveStockResponse|bool
     */
    public function reserveStock($customerNumber, $userCredential, $productNumber, $holdQuantity, $requiredDate, $holdTime)
    {
        try {
            $this->setResult($this->getSoapClient()->reserveStock($customerNumber, $userCredential, $productNumber, $holdQuantity, $requiredDate, $holdTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReserveStockResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
