<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanionProductInventoryLevels StructType
 * @subpackage Structs
 */
class CompanionProductInventoryLevels extends AbstractStructBase
{
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The productColorInventories
     * Meta information extracted from the WSDL
     * - arrayType: tns:ProductColorInventory[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ProductColorInventory[]
     */
    public $productColorInventories;
    /**
     * The companionProductInventoryLevels
     * Meta information extracted from the WSDL
     * - arrayType: tns:CompanionProductInventoryLevels[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\CompanionProductInventoryLevels[]
     */
    public $companionProductInventoryLevels;
    /**
     * Constructor method for CompanionProductInventoryLevels
     * @uses CompanionProductInventoryLevels::setLabel()
     * @uses CompanionProductInventoryLevels::setProductNumber()
     * @uses CompanionProductInventoryLevels::setProductColorInventories()
     * @uses CompanionProductInventoryLevels::setCompanionProductInventoryLevels()
     * @param string $label
     * @param string $productNumber
     * @param \StructType\ProductColorInventory[] $productColorInventories
     * @param \StructType\CompanionProductInventoryLevels[] $companionProductInventoryLevels
     */
    public function __construct($label = null, $productNumber = null, array $productColorInventories = array(), array $companionProductInventoryLevels = array())
    {
        $this
            ->setLabel($label)
            ->setProductNumber($productNumber)
            ->setProductColorInventories($productColorInventories)
            ->setCompanionProductInventoryLevels($companionProductInventoryLevels);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get productColorInventories value
     * @return \StructType\ProductColorInventory[]|null
     */
    public function getProductColorInventories()
    {
        return $this->productColorInventories;
    }
    /**
     * This method is responsible for validating the values passed to the setProductColorInventories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductColorInventories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductColorInventoriesForArrayConstraintsFromSetProductColorInventories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companionProductInventoryLevelsProductColorInventoriesItem) {
            // validation for constraint: itemType
            if (!$companionProductInventoryLevelsProductColorInventoriesItem instanceof \StructType\ProductColorInventory) {
                $invalidValues[] = is_object($companionProductInventoryLevelsProductColorInventoriesItem) ? get_class($companionProductInventoryLevelsProductColorInventoriesItem) : sprintf('%s(%s)', gettype($companionProductInventoryLevelsProductColorInventoriesItem), var_export($companionProductInventoryLevelsProductColorInventoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productColorInventories property can only contain items of type \StructType\ProductColorInventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productColorInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductColorInventory[] $productColorInventories
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function setProductColorInventories(array $productColorInventories = array())
    {
        // validation for constraint: array
        if ('' !== ($productColorInventoriesArrayErrorMessage = self::validateProductColorInventoriesForArrayConstraintsFromSetProductColorInventories($productColorInventories))) {
            throw new \InvalidArgumentException($productColorInventoriesArrayErrorMessage, __LINE__);
        }
        $this->productColorInventories = $productColorInventories;
        return $this;
    }
    /**
     * Add item to productColorInventories value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductColorInventory $item
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function addToProductColorInventories(\StructType\ProductColorInventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductColorInventory) {
            throw new \InvalidArgumentException(sprintf('The productColorInventories property can only contain items of type \StructType\ProductColorInventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productColorInventories[] = $item;
        return $this;
    }
    /**
     * Get companionProductInventoryLevels value
     * @return \StructType\CompanionProductInventoryLevels[]|null
     */
    public function getCompanionProductInventoryLevels()
    {
        return $this->companionProductInventoryLevels;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanionProductInventoryLevels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanionProductInventoryLevels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanionProductInventoryLevelsForArrayConstraintsFromSetCompanionProductInventoryLevels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companionProductInventoryLevelsCompanionProductInventoryLevelsItem) {
            // validation for constraint: itemType
            if (!$companionProductInventoryLevelsCompanionProductInventoryLevelsItem instanceof \StructType\CompanionProductInventoryLevels) {
                $invalidValues[] = is_object($companionProductInventoryLevelsCompanionProductInventoryLevelsItem) ? get_class($companionProductInventoryLevelsCompanionProductInventoryLevelsItem) : sprintf('%s(%s)', gettype($companionProductInventoryLevelsCompanionProductInventoryLevelsItem), var_export($companionProductInventoryLevelsCompanionProductInventoryLevelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The companionProductInventoryLevels property can only contain items of type \StructType\CompanionProductInventoryLevels, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set companionProductInventoryLevels value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanionProductInventoryLevels[] $companionProductInventoryLevels
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function setCompanionProductInventoryLevels(array $companionProductInventoryLevels = array())
    {
        // validation for constraint: array
        if ('' !== ($companionProductInventoryLevelsArrayErrorMessage = self::validateCompanionProductInventoryLevelsForArrayConstraintsFromSetCompanionProductInventoryLevels($companionProductInventoryLevels))) {
            throw new \InvalidArgumentException($companionProductInventoryLevelsArrayErrorMessage, __LINE__);
        }
        $this->companionProductInventoryLevels = $companionProductInventoryLevels;
        return $this;
    }
    /**
     * Add item to companionProductInventoryLevels value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanionProductInventoryLevels $item
     * @return \StructType\CompanionProductInventoryLevels
     */
    public function addToCompanionProductInventoryLevels(\StructType\CompanionProductInventoryLevels $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanionProductInventoryLevels) {
            throw new \InvalidArgumentException(sprintf('The companionProductInventoryLevels property can only contain items of type \StructType\CompanionProductInventoryLevels, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->companionProductInventoryLevels[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanionProductInventoryLevels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
