<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getLevels
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $includeOutlet
     * @param string $includeCompanionPart
     * @return \StructType\InventoryLevels|bool
     */
    public function getLevels($customerNumber, $userCredential, $productNumber, $includeOutlet, $includeCompanionPart)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevels($customerNumber, $userCredential, $productNumber, $includeOutlet, $includeCompanionPart));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsWh30
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data for wh 30 only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $partNumber
     * @param string $useCache
     * @return \StructType\InventoryLevels|bool
     */
    public function getLevelsWh30($customerNumber, $userCredential, $productNumber, $partNumber, $useCache)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsWh30($customerNumber, $userCredential, $productNumber, $partNumber, $useCache));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsBlowout
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data for blowout items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\InventoryLevels|bool
     */
    public function getLevelsBlowout($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsBlowout($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsOutlet
     * Meta information extracted from the WSDL
     * - documentation: Gets the inventory levels data for outlet items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\InventoryLevels|bool
     */
    public function getLevelsOutlet($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsOutlet($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InventoryLevels
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
