<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingOption StructType
 * @subpackage Structs
 */
class ShippingOption extends AbstractStructBase
{
    /**
     * The serviceName
     * @var string
     */
    public $serviceName;
    /**
     * The units
     * @var string
     */
    public $units;
    /**
     * The deliveryDay
     * @var string
     */
    public $deliveryDay;
    /**
     * The deliveryDate
     * @var string
     */
    public $deliveryDate;
    /**
     * The transitTime
     * @var string
     */
    public $transitTime;
    /**
     * The totalBillingWeight
     * @var float
     */
    public $totalBillingWeight;
    /**
     * The totalNetCharge
     * @var float
     */
    public $totalNetCharge;
    /**
     * The totalBaseCharge
     * @var float
     */
    public $totalBaseCharge;
    /**
     * The totalFreightDiscounts
     * @var float
     */
    public $totalFreightDiscounts;
    /**
     * The totalSurcharges
     * @var float
     */
    public $totalSurcharges;
    /**
     * The totalHandlingCharge
     * @var float
     */
    public $totalHandlingCharge;
    /**
     * The totalCustomerCharge
     * @var float
     */
    public $totalCustomerCharge;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * Constructor method for ShippingOption
     * @uses ShippingOption::setServiceName()
     * @uses ShippingOption::setUnits()
     * @uses ShippingOption::setDeliveryDay()
     * @uses ShippingOption::setDeliveryDate()
     * @uses ShippingOption::setTransitTime()
     * @uses ShippingOption::setTotalBillingWeight()
     * @uses ShippingOption::setTotalNetCharge()
     * @uses ShippingOption::setTotalBaseCharge()
     * @uses ShippingOption::setTotalFreightDiscounts()
     * @uses ShippingOption::setTotalSurcharges()
     * @uses ShippingOption::setTotalHandlingCharge()
     * @uses ShippingOption::setTotalCustomerCharge()
     * @uses ShippingOption::setCurrency()
     * @param string $serviceName
     * @param string $units
     * @param string $deliveryDay
     * @param string $deliveryDate
     * @param string $transitTime
     * @param float $totalBillingWeight
     * @param float $totalNetCharge
     * @param float $totalBaseCharge
     * @param float $totalFreightDiscounts
     * @param float $totalSurcharges
     * @param float $totalHandlingCharge
     * @param float $totalCustomerCharge
     * @param string $currency
     */
    public function __construct($serviceName = null, $units = null, $deliveryDay = null, $deliveryDate = null, $transitTime = null, $totalBillingWeight = null, $totalNetCharge = null, $totalBaseCharge = null, $totalFreightDiscounts = null, $totalSurcharges = null, $totalHandlingCharge = null, $totalCustomerCharge = null, $currency = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUnits($units)
            ->setDeliveryDay($deliveryDay)
            ->setDeliveryDate($deliveryDate)
            ->setTransitTime($transitTime)
            ->setTotalBillingWeight($totalBillingWeight)
            ->setTotalNetCharge($totalNetCharge)
            ->setTotalBaseCharge($totalBaseCharge)
            ->setTotalFreightDiscounts($totalFreightDiscounts)
            ->setTotalSurcharges($totalSurcharges)
            ->setTotalHandlingCharge($totalHandlingCharge)
            ->setTotalCustomerCharge($totalCustomerCharge)
            ->setCurrency($currency);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \StructType\ShippingOption
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get units value
     * @return string|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param string $units
     * @return \StructType\ShippingOption
     */
    public function setUnits($units = null)
    {
        // validation for constraint: string
        if (!is_null($units) && !is_string($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get deliveryDay value
     * @return string|null
     */
    public function getDeliveryDay()
    {
        return $this->deliveryDay;
    }
    /**
     * Set deliveryDay value
     * @param string $deliveryDay
     * @return \StructType\ShippingOption
     */
    public function setDeliveryDay($deliveryDay = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDay) && !is_string($deliveryDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDay, true), gettype($deliveryDay)), __LINE__);
        }
        $this->deliveryDay = $deliveryDay;
        return $this;
    }
    /**
     * Get deliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return \StructType\ShippingOption
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get transitTime value
     * @return string|null
     */
    public function getTransitTime()
    {
        return $this->transitTime;
    }
    /**
     * Set transitTime value
     * @param string $transitTime
     * @return \StructType\ShippingOption
     */
    public function setTransitTime($transitTime = null)
    {
        // validation for constraint: string
        if (!is_null($transitTime) && !is_string($transitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transitTime, true), gettype($transitTime)), __LINE__);
        }
        $this->transitTime = $transitTime;
        return $this;
    }
    /**
     * Get totalBillingWeight value
     * @return float|null
     */
    public function getTotalBillingWeight()
    {
        return $this->totalBillingWeight;
    }
    /**
     * Set totalBillingWeight value
     * @param float $totalBillingWeight
     * @return \StructType\ShippingOption
     */
    public function setTotalBillingWeight($totalBillingWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalBillingWeight) && !(is_float($totalBillingWeight) || is_numeric($totalBillingWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalBillingWeight, true), gettype($totalBillingWeight)), __LINE__);
        }
        $this->totalBillingWeight = $totalBillingWeight;
        return $this;
    }
    /**
     * Get totalNetCharge value
     * @return float|null
     */
    public function getTotalNetCharge()
    {
        return $this->totalNetCharge;
    }
    /**
     * Set totalNetCharge value
     * @param float $totalNetCharge
     * @return \StructType\ShippingOption
     */
    public function setTotalNetCharge($totalNetCharge = null)
    {
        // validation for constraint: float
        if (!is_null($totalNetCharge) && !(is_float($totalNetCharge) || is_numeric($totalNetCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalNetCharge, true), gettype($totalNetCharge)), __LINE__);
        }
        $this->totalNetCharge = $totalNetCharge;
        return $this;
    }
    /**
     * Get totalBaseCharge value
     * @return float|null
     */
    public function getTotalBaseCharge()
    {
        return $this->totalBaseCharge;
    }
    /**
     * Set totalBaseCharge value
     * @param float $totalBaseCharge
     * @return \StructType\ShippingOption
     */
    public function setTotalBaseCharge($totalBaseCharge = null)
    {
        // validation for constraint: float
        if (!is_null($totalBaseCharge) && !(is_float($totalBaseCharge) || is_numeric($totalBaseCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalBaseCharge, true), gettype($totalBaseCharge)), __LINE__);
        }
        $this->totalBaseCharge = $totalBaseCharge;
        return $this;
    }
    /**
     * Get totalFreightDiscounts value
     * @return float|null
     */
    public function getTotalFreightDiscounts()
    {
        return $this->totalFreightDiscounts;
    }
    /**
     * Set totalFreightDiscounts value
     * @param float $totalFreightDiscounts
     * @return \StructType\ShippingOption
     */
    public function setTotalFreightDiscounts($totalFreightDiscounts = null)
    {
        // validation for constraint: float
        if (!is_null($totalFreightDiscounts) && !(is_float($totalFreightDiscounts) || is_numeric($totalFreightDiscounts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFreightDiscounts, true), gettype($totalFreightDiscounts)), __LINE__);
        }
        $this->totalFreightDiscounts = $totalFreightDiscounts;
        return $this;
    }
    /**
     * Get totalSurcharges value
     * @return float|null
     */
    public function getTotalSurcharges()
    {
        return $this->totalSurcharges;
    }
    /**
     * Set totalSurcharges value
     * @param float $totalSurcharges
     * @return \StructType\ShippingOption
     */
    public function setTotalSurcharges($totalSurcharges = null)
    {
        // validation for constraint: float
        if (!is_null($totalSurcharges) && !(is_float($totalSurcharges) || is_numeric($totalSurcharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSurcharges, true), gettype($totalSurcharges)), __LINE__);
        }
        $this->totalSurcharges = $totalSurcharges;
        return $this;
    }
    /**
     * Get totalHandlingCharge value
     * @return float|null
     */
    public function getTotalHandlingCharge()
    {
        return $this->totalHandlingCharge;
    }
    /**
     * Set totalHandlingCharge value
     * @param float $totalHandlingCharge
     * @return \StructType\ShippingOption
     */
    public function setTotalHandlingCharge($totalHandlingCharge = null)
    {
        // validation for constraint: float
        if (!is_null($totalHandlingCharge) && !(is_float($totalHandlingCharge) || is_numeric($totalHandlingCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalHandlingCharge, true), gettype($totalHandlingCharge)), __LINE__);
        }
        $this->totalHandlingCharge = $totalHandlingCharge;
        return $this;
    }
    /**
     * Get totalCustomerCharge value
     * @return float|null
     */
    public function getTotalCustomerCharge()
    {
        return $this->totalCustomerCharge;
    }
    /**
     * Set totalCustomerCharge value
     * @param float $totalCustomerCharge
     * @return \StructType\ShippingOption
     */
    public function setTotalCustomerCharge($totalCustomerCharge = null)
    {
        // validation for constraint: float
        if (!is_null($totalCustomerCharge) && !(is_float($totalCustomerCharge) || is_numeric($totalCustomerCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCustomerCharge, true), gettype($totalCustomerCharge)), __LINE__);
        }
        $this->totalCustomerCharge = $totalCustomerCharge;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ShippingOption
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
