<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The poNumber
     * @var string
     */
    public $poNumber;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The trackingNumber
     * @var string
     */
    public $trackingNumber;
    /**
     * The service
     * @var string
     */
    public $service;
    /**
     * The zipCode
     * @var string
     */
    public $zipCode;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setCustomerNumber()
     * @uses Shipment::setPoNumber()
     * @uses Shipment::setOrderNumber()
     * @uses Shipment::setTrackingNumber()
     * @uses Shipment::setService()
     * @uses Shipment::setZipCode()
     * @param string $customerNumber
     * @param string $poNumber
     * @param string $orderNumber
     * @param string $trackingNumber
     * @param string $service
     * @param string $zipCode
     */
    public function __construct($customerNumber = null, $poNumber = null, $orderNumber = null, $trackingNumber = null, $service = null, $zipCode = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setPoNumber($poNumber)
            ->setOrderNumber($orderNumber)
            ->setTrackingNumber($trackingNumber)
            ->setService($service)
            ->setZipCode($zipCode);
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\Shipment
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get poNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
    /**
     * Set poNumber value
     * @param string $poNumber
     * @return \StructType\Shipment
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->poNumber = $poNumber;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Shipment
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get trackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->trackingNumber;
    }
    /**
     * Set trackingNumber value
     * @param string $trackingNumber
     * @return \StructType\Shipment
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->trackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\Shipment
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\Shipment
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
