<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/shipping',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ds.hitpromo.net/shipping',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getRatesLtl2 operation/method
 */
if ($get->getRatesLtl2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRatesLtl operation/method
 */
if ($get->getRatesLtl($customerNumber, $userCredential, $productNumber, $quantity, $postalState, $destZip, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRatesLtlNoState operation/method
 */
if ($get->getRatesLtlNoState($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrderShipments operation/method
 */
if ($get->getOrderShipments($customerNumber, $userCredential, $poNumber) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInboundRatesNoLTL operation/method
 */
if ($get->getInboundRatesNoLTL($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInboundRatesUps operation/method
 */
if ($get->getInboundRatesUps($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInboundRates operation/method
 */
if ($get->getInboundRates($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $isResidential, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAdmintsFillersShipQuote operation/method
 */
if ($get->getAdmintsFillersShipQuote($customerNumber, $userCredential, $productNumber, $fillerCode, $quantity, $destZip, $isResidential, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInHandsDate operation/method
 */
if ($get->getInHandsDate($customerNumber, $userCredential, $transitDays, $productNumber, $rushTime) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInboundRatesUpsProfill operation/method
 */
if ($get->getInboundRatesUpsProfill($userCredential, $weight, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAdvanceShipments operation/method
 */
if ($get->getAdvanceShipments($customerNumber, $userCredential, $date) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRates operation/method
 */
if ($get->getRates($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRates2 operation/method
 */
if ($get->getRates2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
