<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingQuote StructType
 * @subpackage Structs
 */
class ShippingQuote extends AbstractStructBase
{
    /**
     * The isLtl
     * @var bool
     */
    public $isLtl;
    /**
     * The isResidential
     * @var bool
     */
    public $isResidential;
    /**
     * The isCanada
     * @var bool
     */
    public $isCanada;
    /**
     * The quoteId
     * @var string
     */
    public $quoteId;
    /**
     * The shipDate
     * @var string
     */
    public $shipDate;
    /**
     * The shippingOptions
     * Meta information extracted from the WSDL
     * - arrayType: tns:ShippingOption[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ShippingOption[]
     */
    public $shippingOptions;
    /**
     * The totalWeight
     * @var string
     */
    public $totalWeight;
    /**
     * The totalPackages
     * @var string
     */
    public $totalPackages;
    /**
     * The origin
     * @var \StructType\Origin
     */
    public $origin;
    /**
     * The destination
     * @var \StructType\Destination
     */
    public $destination;
    /**
     * The packedProduct
     * @var \StructType\PackedProduct
     */
    public $packedProduct;
    /**
     * The palletCount
     * @var int
     */
    public $palletCount;
    /**
     * Constructor method for ShippingQuote
     * @uses ShippingQuote::setIsLtl()
     * @uses ShippingQuote::setIsResidential()
     * @uses ShippingQuote::setIsCanada()
     * @uses ShippingQuote::setQuoteId()
     * @uses ShippingQuote::setShipDate()
     * @uses ShippingQuote::setShippingOptions()
     * @uses ShippingQuote::setTotalWeight()
     * @uses ShippingQuote::setTotalPackages()
     * @uses ShippingQuote::setOrigin()
     * @uses ShippingQuote::setDestination()
     * @uses ShippingQuote::setPackedProduct()
     * @uses ShippingQuote::setPalletCount()
     * @param bool $isLtl
     * @param bool $isResidential
     * @param bool $isCanada
     * @param string $quoteId
     * @param string $shipDate
     * @param \StructType\ShippingOption[] $shippingOptions
     * @param string $totalWeight
     * @param string $totalPackages
     * @param \StructType\Origin $origin
     * @param \StructType\Destination $destination
     * @param \StructType\PackedProduct $packedProduct
     * @param int $palletCount
     */
    public function __construct($isLtl = null, $isResidential = null, $isCanada = null, $quoteId = null, $shipDate = null, array $shippingOptions = array(), $totalWeight = null, $totalPackages = null, \StructType\Origin $origin = null, \StructType\Destination $destination = null, \StructType\PackedProduct $packedProduct = null, $palletCount = null)
    {
        $this
            ->setIsLtl($isLtl)
            ->setIsResidential($isResidential)
            ->setIsCanada($isCanada)
            ->setQuoteId($quoteId)
            ->setShipDate($shipDate)
            ->setShippingOptions($shippingOptions)
            ->setTotalWeight($totalWeight)
            ->setTotalPackages($totalPackages)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setPackedProduct($packedProduct)
            ->setPalletCount($palletCount);
    }
    /**
     * Get isLtl value
     * @return bool|null
     */
    public function getIsLtl()
    {
        return $this->isLtl;
    }
    /**
     * Set isLtl value
     * @param bool $isLtl
     * @return \StructType\ShippingQuote
     */
    public function setIsLtl($isLtl = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLtl) && !is_bool($isLtl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLtl, true), gettype($isLtl)), __LINE__);
        }
        $this->isLtl = $isLtl;
        return $this;
    }
    /**
     * Get isResidential value
     * @return bool|null
     */
    public function getIsResidential()
    {
        return $this->isResidential;
    }
    /**
     * Set isResidential value
     * @param bool $isResidential
     * @return \StructType\ShippingQuote
     */
    public function setIsResidential($isResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResidential) && !is_bool($isResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResidential, true), gettype($isResidential)), __LINE__);
        }
        $this->isResidential = $isResidential;
        return $this;
    }
    /**
     * Get isCanada value
     * @return bool|null
     */
    public function getIsCanada()
    {
        return $this->isCanada;
    }
    /**
     * Set isCanada value
     * @param bool $isCanada
     * @return \StructType\ShippingQuote
     */
    public function setIsCanada($isCanada = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCanada) && !is_bool($isCanada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCanada, true), gettype($isCanada)), __LINE__);
        }
        $this->isCanada = $isCanada;
        return $this;
    }
    /**
     * Get quoteId value
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param string $quoteId
     * @return \StructType\ShippingQuote
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: string
        if (!is_null($quoteId) && !is_string($quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\ShippingQuote
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shippingOptions value
     * @return \StructType\ShippingOption[]|null
     */
    public function getShippingOptions()
    {
        return $this->shippingOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingOptionsForArrayConstraintsFromSetShippingOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingQuoteShippingOptionsItem) {
            // validation for constraint: itemType
            if (!$shippingQuoteShippingOptionsItem instanceof \StructType\ShippingOption) {
                $invalidValues[] = is_object($shippingQuoteShippingOptionsItem) ? get_class($shippingQuoteShippingOptionsItem) : sprintf('%s(%s)', gettype($shippingQuoteShippingOptionsItem), var_export($shippingQuoteShippingOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shippingOptions property can only contain items of type \StructType\ShippingOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shippingOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOption[] $shippingOptions
     * @return \StructType\ShippingQuote
     */
    public function setShippingOptions(array $shippingOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingOptionsArrayErrorMessage = self::validateShippingOptionsForArrayConstraintsFromSetShippingOptions($shippingOptions))) {
            throw new \InvalidArgumentException($shippingOptionsArrayErrorMessage, __LINE__);
        }
        $this->shippingOptions = $shippingOptions;
        return $this;
    }
    /**
     * Add item to shippingOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOption $item
     * @return \StructType\ShippingQuote
     */
    public function addToShippingOptions(\StructType\ShippingOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingOption) {
            throw new \InvalidArgumentException(sprintf('The shippingOptions property can only contain items of type \StructType\ShippingOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shippingOptions[] = $item;
        return $this;
    }
    /**
     * Get totalWeight value
     * @return string|null
     */
    public function getTotalWeight()
    {
        return $this->totalWeight;
    }
    /**
     * Set totalWeight value
     * @param string $totalWeight
     * @return \StructType\ShippingQuote
     */
    public function setTotalWeight($totalWeight = null)
    {
        // validation for constraint: string
        if (!is_null($totalWeight) && !is_string($totalWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalWeight, true), gettype($totalWeight)), __LINE__);
        }
        $this->totalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get totalPackages value
     * @return string|null
     */
    public function getTotalPackages()
    {
        return $this->totalPackages;
    }
    /**
     * Set totalPackages value
     * @param string $totalPackages
     * @return \StructType\ShippingQuote
     */
    public function setTotalPackages($totalPackages = null)
    {
        // validation for constraint: string
        if (!is_null($totalPackages) && !is_string($totalPackages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalPackages, true), gettype($totalPackages)), __LINE__);
        }
        $this->totalPackages = $totalPackages;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\Origin|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\Origin $origin
     * @return \StructType\ShippingQuote
     */
    public function setOrigin(\StructType\Origin $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get destination value
     * @return \StructType\Destination|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \StructType\Destination $destination
     * @return \StructType\ShippingQuote
     */
    public function setDestination(\StructType\Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get packedProduct value
     * @return \StructType\PackedProduct|null
     */
    public function getPackedProduct()
    {
        return $this->packedProduct;
    }
    /**
     * Set packedProduct value
     * @param \StructType\PackedProduct $packedProduct
     * @return \StructType\ShippingQuote
     */
    public function setPackedProduct(\StructType\PackedProduct $packedProduct = null)
    {
        $this->packedProduct = $packedProduct;
        return $this;
    }
    /**
     * Get palletCount value
     * @return int|null
     */
    public function getPalletCount()
    {
        return $this->palletCount;
    }
    /**
     * Set palletCount value
     * @param int $palletCount
     * @return \StructType\ShippingQuote
     */
    public function setPalletCount($palletCount = null)
    {
        // validation for constraint: int
        if (!is_null($palletCount) && !(is_int($palletCount) || ctype_digit($palletCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($palletCount, true), gettype($palletCount)), __LINE__);
        }
        $this->palletCount = $palletCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingQuote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
