<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackedProduct StructType
 * @subpackage Structs
 */
class PackedProduct extends AbstractStructBase
{
    /**
     * The proNumber
     * @var string
     */
    public $proNumber;
    /**
     * The proName
     * @var string
     */
    public $proName;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The numBoxes
     * @var string
     */
    public $numBoxes;
    /**
     * The productWeight
     * @var string
     */
    public $productWeight;
    /**
     * The orderItemWeight
     * @var string
     */
    public $orderItemWeight;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - arrayType: tns:package[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\Package[]
     */
    public $packages;
    /**
     * Constructor method for PackedProduct
     * @uses PackedProduct::setProNumber()
     * @uses PackedProduct::setProName()
     * @uses PackedProduct::setQuantity()
     * @uses PackedProduct::setNumBoxes()
     * @uses PackedProduct::setProductWeight()
     * @uses PackedProduct::setOrderItemWeight()
     * @uses PackedProduct::setPackages()
     * @param string $proNumber
     * @param string $proName
     * @param string $quantity
     * @param string $numBoxes
     * @param string $productWeight
     * @param string $orderItemWeight
     * @param \StructType\Package[] $packages
     */
    public function __construct($proNumber = null, $proName = null, $quantity = null, $numBoxes = null, $productWeight = null, $orderItemWeight = null, array $packages = array())
    {
        $this
            ->setProNumber($proNumber)
            ->setProName($proName)
            ->setQuantity($quantity)
            ->setNumBoxes($numBoxes)
            ->setProductWeight($productWeight)
            ->setOrderItemWeight($orderItemWeight)
            ->setPackages($packages);
    }
    /**
     * Get proNumber value
     * @return string|null
     */
    public function getProNumber()
    {
        return $this->proNumber;
    }
    /**
     * Set proNumber value
     * @param string $proNumber
     * @return \StructType\PackedProduct
     */
    public function setProNumber($proNumber = null)
    {
        // validation for constraint: string
        if (!is_null($proNumber) && !is_string($proNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proNumber, true), gettype($proNumber)), __LINE__);
        }
        $this->proNumber = $proNumber;
        return $this;
    }
    /**
     * Get proName value
     * @return string|null
     */
    public function getProName()
    {
        return $this->proName;
    }
    /**
     * Set proName value
     * @param string $proName
     * @return \StructType\PackedProduct
     */
    public function setProName($proName = null)
    {
        // validation for constraint: string
        if (!is_null($proName) && !is_string($proName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proName, true), gettype($proName)), __LINE__);
        }
        $this->proName = $proName;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\PackedProduct
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get numBoxes value
     * @return string|null
     */
    public function getNumBoxes()
    {
        return $this->numBoxes;
    }
    /**
     * Set numBoxes value
     * @param string $numBoxes
     * @return \StructType\PackedProduct
     */
    public function setNumBoxes($numBoxes = null)
    {
        // validation for constraint: string
        if (!is_null($numBoxes) && !is_string($numBoxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numBoxes, true), gettype($numBoxes)), __LINE__);
        }
        $this->numBoxes = $numBoxes;
        return $this;
    }
    /**
     * Get productWeight value
     * @return string|null
     */
    public function getProductWeight()
    {
        return $this->productWeight;
    }
    /**
     * Set productWeight value
     * @param string $productWeight
     * @return \StructType\PackedProduct
     */
    public function setProductWeight($productWeight = null)
    {
        // validation for constraint: string
        if (!is_null($productWeight) && !is_string($productWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productWeight, true), gettype($productWeight)), __LINE__);
        }
        $this->productWeight = $productWeight;
        return $this;
    }
    /**
     * Get orderItemWeight value
     * @return string|null
     */
    public function getOrderItemWeight()
    {
        return $this->orderItemWeight;
    }
    /**
     * Set orderItemWeight value
     * @param string $orderItemWeight
     * @return \StructType\PackedProduct
     */
    public function setOrderItemWeight($orderItemWeight = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemWeight) && !is_string($orderItemWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemWeight, true), gettype($orderItemWeight)), __LINE__);
        }
        $this->orderItemWeight = $orderItemWeight;
        return $this;
    }
    /**
     * Get packages value
     * @return \StructType\Package[]|null
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packedProductPackagesItem) {
            // validation for constraint: itemType
            if (!$packedProductPackagesItem instanceof \StructType\Package) {
                $invalidValues[] = is_object($packedProductPackagesItem) ? get_class($packedProductPackagesItem) : sprintf('%s(%s)', gettype($packedProductPackagesItem), var_export($packedProductPackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \StructType\Package, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * @throws \InvalidArgumentException
     * @param \StructType\Package[] $packages
     * @return \StructType\PackedProduct
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \StructType\Package $item
     * @return \StructType\PackedProduct
     */
    public function addToPackages(\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \StructType\Package, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackedProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
