<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for package StructType
 * @subpackage Structs
 */
class Package extends AbstractStructBase
{
    /**
     * The pkgWeight
     * @var float
     */
    public $pkgWeight;
    /**
     * The pkgQuantityInBox
     * @var float
     */
    public $pkgQuantityInBox;
    /**
     * The proBoxLength
     * @var float
     */
    public $proBoxLength;
    /**
     * The proBoxWidth
     * @var float
     */
    public $proBoxWidth;
    /**
     * The proBoxHeight
     * @var float
     */
    public $proBoxHeight;
    /**
     * The boxType
     * @var string
     */
    public $boxType;
    /**
     * The boxCode
     * @var string
     */
    public $boxCode;
    /**
     * Constructor method for package
     * @uses Package::setPkgWeight()
     * @uses Package::setPkgQuantityInBox()
     * @uses Package::setProBoxLength()
     * @uses Package::setProBoxWidth()
     * @uses Package::setProBoxHeight()
     * @uses Package::setBoxType()
     * @uses Package::setBoxCode()
     * @param float $pkgWeight
     * @param float $pkgQuantityInBox
     * @param float $proBoxLength
     * @param float $proBoxWidth
     * @param float $proBoxHeight
     * @param string $boxType
     * @param string $boxCode
     */
    public function __construct($pkgWeight = null, $pkgQuantityInBox = null, $proBoxLength = null, $proBoxWidth = null, $proBoxHeight = null, $boxType = null, $boxCode = null)
    {
        $this
            ->setPkgWeight($pkgWeight)
            ->setPkgQuantityInBox($pkgQuantityInBox)
            ->setProBoxLength($proBoxLength)
            ->setProBoxWidth($proBoxWidth)
            ->setProBoxHeight($proBoxHeight)
            ->setBoxType($boxType)
            ->setBoxCode($boxCode);
    }
    /**
     * Get pkgWeight value
     * @return float|null
     */
    public function getPkgWeight()
    {
        return $this->pkgWeight;
    }
    /**
     * Set pkgWeight value
     * @param float $pkgWeight
     * @return \StructType\Package
     */
    public function setPkgWeight($pkgWeight = null)
    {
        // validation for constraint: float
        if (!is_null($pkgWeight) && !(is_float($pkgWeight) || is_numeric($pkgWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pkgWeight, true), gettype($pkgWeight)), __LINE__);
        }
        $this->pkgWeight = $pkgWeight;
        return $this;
    }
    /**
     * Get pkgQuantityInBox value
     * @return float|null
     */
    public function getPkgQuantityInBox()
    {
        return $this->pkgQuantityInBox;
    }
    /**
     * Set pkgQuantityInBox value
     * @param float $pkgQuantityInBox
     * @return \StructType\Package
     */
    public function setPkgQuantityInBox($pkgQuantityInBox = null)
    {
        // validation for constraint: float
        if (!is_null($pkgQuantityInBox) && !(is_float($pkgQuantityInBox) || is_numeric($pkgQuantityInBox))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pkgQuantityInBox, true), gettype($pkgQuantityInBox)), __LINE__);
        }
        $this->pkgQuantityInBox = $pkgQuantityInBox;
        return $this;
    }
    /**
     * Get proBoxLength value
     * @return float|null
     */
    public function getProBoxLength()
    {
        return $this->proBoxLength;
    }
    /**
     * Set proBoxLength value
     * @param float $proBoxLength
     * @return \StructType\Package
     */
    public function setProBoxLength($proBoxLength = null)
    {
        // validation for constraint: float
        if (!is_null($proBoxLength) && !(is_float($proBoxLength) || is_numeric($proBoxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proBoxLength, true), gettype($proBoxLength)), __LINE__);
        }
        $this->proBoxLength = $proBoxLength;
        return $this;
    }
    /**
     * Get proBoxWidth value
     * @return float|null
     */
    public function getProBoxWidth()
    {
        return $this->proBoxWidth;
    }
    /**
     * Set proBoxWidth value
     * @param float $proBoxWidth
     * @return \StructType\Package
     */
    public function setProBoxWidth($proBoxWidth = null)
    {
        // validation for constraint: float
        if (!is_null($proBoxWidth) && !(is_float($proBoxWidth) || is_numeric($proBoxWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proBoxWidth, true), gettype($proBoxWidth)), __LINE__);
        }
        $this->proBoxWidth = $proBoxWidth;
        return $this;
    }
    /**
     * Get proBoxHeight value
     * @return float|null
     */
    public function getProBoxHeight()
    {
        return $this->proBoxHeight;
    }
    /**
     * Set proBoxHeight value
     * @param float $proBoxHeight
     * @return \StructType\Package
     */
    public function setProBoxHeight($proBoxHeight = null)
    {
        // validation for constraint: float
        if (!is_null($proBoxHeight) && !(is_float($proBoxHeight) || is_numeric($proBoxHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proBoxHeight, true), gettype($proBoxHeight)), __LINE__);
        }
        $this->proBoxHeight = $proBoxHeight;
        return $this;
    }
    /**
     * Get boxType value
     * @return string|null
     */
    public function getBoxType()
    {
        return $this->boxType;
    }
    /**
     * Set boxType value
     * @param string $boxType
     * @return \StructType\Package
     */
    public function setBoxType($boxType = null)
    {
        // validation for constraint: string
        if (!is_null($boxType) && !is_string($boxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxType, true), gettype($boxType)), __LINE__);
        }
        $this->boxType = $boxType;
        return $this;
    }
    /**
     * Get boxCode value
     * @return string|null
     */
    public function getBoxCode()
    {
        return $this->boxCode;
    }
    /**
     * Set boxCode value
     * @param string $boxCode
     * @return \StructType\Package
     */
    public function setBoxCode($boxCode = null)
    {
        // validation for constraint: string
        if (!is_null($boxCode) && !is_string($boxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxCode, true), gettype($boxCode)), __LINE__);
        }
        $this->boxCode = $boxCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Package
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
