<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InHandsDate StructType
 * @subpackage Structs
 */
class InHandsDate extends AbstractStructBase
{
    /**
     * The inHandsDate
     * @var string
     */
    public $inHandsDate;
    /**
     * The productionTimeInCalculation
     * @var string
     */
    public $productionTimeInCalculation;
    /**
     * Constructor method for InHandsDate
     * @uses InHandsDate::setInHandsDate()
     * @uses InHandsDate::setProductionTimeInCalculation()
     * @param string $inHandsDate
     * @param string $productionTimeInCalculation
     */
    public function __construct($inHandsDate = null, $productionTimeInCalculation = null)
    {
        $this
            ->setInHandsDate($inHandsDate)
            ->setProductionTimeInCalculation($productionTimeInCalculation);
    }
    /**
     * Get inHandsDate value
     * @return string|null
     */
    public function getInHandsDate()
    {
        return $this->inHandsDate;
    }
    /**
     * Set inHandsDate value
     * @param string $inHandsDate
     * @return \StructType\InHandsDate
     */
    public function setInHandsDate($inHandsDate = null)
    {
        // validation for constraint: string
        if (!is_null($inHandsDate) && !is_string($inHandsDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inHandsDate, true), gettype($inHandsDate)), __LINE__);
        }
        $this->inHandsDate = $inHandsDate;
        return $this;
    }
    /**
     * Get productionTimeInCalculation value
     * @return string|null
     */
    public function getProductionTimeInCalculation()
    {
        return $this->productionTimeInCalculation;
    }
    /**
     * Set productionTimeInCalculation value
     * @param string $productionTimeInCalculation
     * @return \StructType\InHandsDate
     */
    public function setProductionTimeInCalculation($productionTimeInCalculation = null)
    {
        // validation for constraint: string
        if (!is_null($productionTimeInCalculation) && !is_string($productionTimeInCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productionTimeInCalculation, true), gettype($productionTimeInCalculation)), __LINE__);
        }
        $this->productionTimeInCalculation = $productionTimeInCalculation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InHandsDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
