<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getRatesLtl2
     * Meta information extracted from the WSDL
     * - documentation: Gets the shipping data including LTL quotes. Does not require the postal state as a param.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $destZip
     * @param string $isResidential
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getRatesLtl2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getRatesLtl2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRatesLtl
     * Meta information extracted from the WSDL
     * - documentation: Gets the shipping data including LTL quotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $postalState
     * @param string $destZip
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getRatesLtl($customerNumber, $userCredential, $productNumber, $quantity, $postalState, $destZip, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getRatesLtl($customerNumber, $userCredential, $productNumber, $quantity, $postalState, $destZip, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRatesLtlNoState
     * Meta information extracted from the WSDL
     * - documentation: Gets the shipping data including LTL quotes. Does not require the postal state as a param.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $destZip
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getRatesLtlNoState($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getRatesLtlNoState($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $poNumber
     * @return \StructType\Shipment[]|bool
     */
    public function getOrderShipments($customerNumber, $userCredential, $poNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrderShipments($customerNumber, $userCredential, $poNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInboundRatesNoLTL
     * Meta information extracted from the WSDL
     * - documentation: Get inbound rates for specified params, save shipping quote to mongoThis will be called for quotes that wantnon-ltl rates and with a specified origin.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $prodnum
     * @param string $quantity
     * @param string $origin
     * @param string $destZip
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getInboundRatesNoLTL($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getInboundRatesNoLTL($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInboundRatesUps
     * Meta information extracted from the WSDL
     * - documentation: Get shipping rates using a customer shipping account number
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $destZip
     * @param string $upsAccountNumber
     * @param string $upsApiKey
     * @param string $upsUsername
     * @param string $upsPassword
     * @param string $origin
     * @param string $isResidential
     * @return \StructType\ShippingQuote|bool
     */
    public function getInboundRatesUps($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential)
    {
        try {
            $this->setResult($this->getSoapClient()->getInboundRatesUps($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInboundRates
     * Meta information extracted from the WSDL
     * - documentation: Get inbound rates for specified params, save shipping quote to mongoThis is different than the other fetch rates functions in this controlleras it gets rates with a specified origin.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $prodnum
     * @param string $quantity
     * @param string $origin
     * @param string $destZip
     * @param string $isResidential
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getInboundRates($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $isResidential, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getInboundRates($customerNumber, $userCredential, $prodnum, $quantity, $origin, $destZip, $isResidential, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdmintsFillersShipQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $fillerCode
     * @param string $quantity
     * @param string $destZip
     * @param string $isResidential
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getAdmintsFillersShipQuote($customerNumber, $userCredential, $productNumber, $fillerCode, $quantity, $destZip, $isResidential, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdmintsFillersShipQuote($customerNumber, $userCredential, $productNumber, $fillerCode, $quantity, $destZip, $isResidential, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInHandsDate
     * Meta information extracted from the WSDL
     * - documentation: This method sends back a date based on the transit time sent and based on the amount of time it would take to producethe product. If the rush field is sent, it overrides the production time.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $transitDays
     * @param string $productNumber
     * @param string $rushTime
     * @return \StructType\InHandsDate|bool
     */
    public function getInHandsDate($customerNumber, $userCredential, $transitDays, $productNumber, $rushTime)
    {
        try {
            $this->setResult($this->getSoapClient()->getInHandsDate($customerNumber, $userCredential, $transitDays, $productNumber, $rushTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInboundRatesUpsProfill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $userCredential
     * @param string $weight
     * @param string $quantity
     * @param string $destZip
     * @param string $upsAccountNumber
     * @param string $upsApiKey
     * @param string $upsUsername
     * @param string $upsPassword
     * @param string $origin
     * @param string $isResidential
     * @return \StructType\LtlShippingQuote|bool
     */
    public function getInboundRatesUpsProfill($userCredential, $weight, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential)
    {
        try {
            $this->setResult($this->getSoapClient()->getInboundRatesUpsProfill($userCredential, $weight, $quantity, $destZip, $upsAccountNumber, $upsApiKey, $upsUsername, $upsPassword, $origin, $isResidential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdvanceShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $date
     * @return \StructType\Shipment[]|bool
     */
    public function getAdvanceShipments($customerNumber, $userCredential, $date)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdvanceShipments($customerNumber, $userCredential, $date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRates
     * Meta information extracted from the WSDL
     * - documentation: Gets the shipping data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $destZip
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getRates($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getRates($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRates2
     * Meta information extracted from the WSDL
     * - documentation: Gets the shipping data.with an extra param indicicating if thedestination address is residential or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $quantity
     * @param string $destZip
     * @param string $isResidential
     * @param string $forCustomer
     * @return \StructType\ShippingQuote|bool
     */
    public function getRates2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->getRates2($customerNumber, $userCredential, $productNumber, $quantity, $destZip, $isResidential, $forCustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InHandsDate|\StructType\LtlShippingQuote|\StructType\Shipment[]|\StructType\ShippingQuote
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
