<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceLine StructType
 * @subpackage Structs
 */
class ReferenceLine extends AbstractStructBase
{
    /**
     * The commodityCode
     * @var string
     */
    public $commodityCode;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The discountAmount
     * @var string
     */
    public $discountAmount;
    /**
     * The discounted
     * @var bool
     */
    public $discounted;
    /**
     * The taxIncluded
     * @var bool
     */
    public $taxIncluded;
    /**
     * The lineItemTotal
     * @var string
     */
    public $lineItemTotal;
    /**
     * The productCode
     * @var string
     */
    public $productCode;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * The unitCost
     * @var string
     */
    public $unitCost;
    /**
     * The unitOfMeasure
     * @var string
     */
    public $unitOfMeasure;
    /**
     * Constructor method for ReferenceLine
     * @uses ReferenceLine::setCommodityCode()
     * @uses ReferenceLine::setDescription()
     * @uses ReferenceLine::setDiscountAmount()
     * @uses ReferenceLine::setDiscounted()
     * @uses ReferenceLine::setTaxIncluded()
     * @uses ReferenceLine::setLineItemTotal()
     * @uses ReferenceLine::setProductCode()
     * @uses ReferenceLine::setQuantity()
     * @uses ReferenceLine::setUnitCost()
     * @uses ReferenceLine::setUnitOfMeasure()
     * @param string $commodityCode
     * @param string $description
     * @param string $discountAmount
     * @param bool $discounted
     * @param bool $taxIncluded
     * @param string $lineItemTotal
     * @param string $productCode
     * @param string $quantity
     * @param string $unitCost
     * @param string $unitOfMeasure
     */
    public function __construct($commodityCode = null, $description = null, $discountAmount = null, $discounted = null, $taxIncluded = null, $lineItemTotal = null, $productCode = null, $quantity = null, $unitCost = null, $unitOfMeasure = null)
    {
        $this
            ->setCommodityCode($commodityCode)
            ->setDescription($description)
            ->setDiscountAmount($discountAmount)
            ->setDiscounted($discounted)
            ->setTaxIncluded($taxIncluded)
            ->setLineItemTotal($lineItemTotal)
            ->setProductCode($productCode)
            ->setQuantity($quantity)
            ->setUnitCost($unitCost)
            ->setUnitOfMeasure($unitOfMeasure);
    }
    /**
     * Get commodityCode value
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->commodityCode;
    }
    /**
     * Set commodityCode value
     * @param string $commodityCode
     * @return \StructType\ReferenceLine
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->commodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ReferenceLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param string $discountAmount
     * @return \StructType\ReferenceLine
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: string
        if (!is_null($discountAmount) && !is_string($discountAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get discounted value
     * @return bool|null
     */
    public function getDiscounted()
    {
        return $this->discounted;
    }
    /**
     * Set discounted value
     * @param bool $discounted
     * @return \StructType\ReferenceLine
     */
    public function setDiscounted($discounted = null)
    {
        // validation for constraint: boolean
        if (!is_null($discounted) && !is_bool($discounted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discounted, true), gettype($discounted)), __LINE__);
        }
        $this->discounted = $discounted;
        return $this;
    }
    /**
     * Get taxIncluded value
     * @return bool|null
     */
    public function getTaxIncluded()
    {
        return $this->taxIncluded;
    }
    /**
     * Set taxIncluded value
     * @param bool $taxIncluded
     * @return \StructType\ReferenceLine
     */
    public function setTaxIncluded($taxIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIncluded) && !is_bool($taxIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxIncluded, true), gettype($taxIncluded)), __LINE__);
        }
        $this->taxIncluded = $taxIncluded;
        return $this;
    }
    /**
     * Get lineItemTotal value
     * @return string|null
     */
    public function getLineItemTotal()
    {
        return $this->lineItemTotal;
    }
    /**
     * Set lineItemTotal value
     * @param string $lineItemTotal
     * @return \StructType\ReferenceLine
     */
    public function setLineItemTotal($lineItemTotal = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemTotal) && !is_string($lineItemTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineItemTotal, true), gettype($lineItemTotal)), __LINE__);
        }
        $this->lineItemTotal = $lineItemTotal;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\ReferenceLine
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\ReferenceLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get unitCost value
     * @return string|null
     */
    public function getUnitCost()
    {
        return $this->unitCost;
    }
    /**
     * Set unitCost value
     * @param string $unitCost
     * @return \StructType\ReferenceLine
     */
    public function setUnitCost($unitCost = null)
    {
        // validation for constraint: string
        if (!is_null($unitCost) && !is_string($unitCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCost, true), gettype($unitCost)), __LINE__);
        }
        $this->unitCost = $unitCost;
        return $this;
    }
    /**
     * Get unitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->unitOfMeasure;
    }
    /**
     * Set unitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\ReferenceLine
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->unitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
