<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStatusCode StructType
 * @subpackage Structs
 */
class OrderStatusCode extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The promoStandardsCode
     * @var string
     */
    public $promoStandardsCode;
    /**
     * Constructor method for OrderStatusCode
     * @uses OrderStatusCode::setCode()
     * @uses OrderStatusCode::setDescription()
     * @uses OrderStatusCode::setPromoStandardsCode()
     * @param string $code
     * @param string $description
     * @param string $promoStandardsCode
     */
    public function __construct($code = null, $description = null, $promoStandardsCode = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setPromoStandardsCode($promoStandardsCode);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\OrderStatusCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\OrderStatusCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get promoStandardsCode value
     * @return string|null
     */
    public function getPromoStandardsCode()
    {
        return $this->promoStandardsCode;
    }
    /**
     * Set promoStandardsCode value
     * @param string $promoStandardsCode
     * @return \StructType\OrderStatusCode
     */
    public function setPromoStandardsCode($promoStandardsCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoStandardsCode) && !is_string($promoStandardsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoStandardsCode, true), gettype($promoStandardsCode)), __LINE__);
        }
        $this->promoStandardsCode = $promoStandardsCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatusCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
