<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStatus StructType
 * @subpackage Structs
 */
class OrderStatus extends AbstractStructBase
{
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The poNumber
     * @var string
     */
    public $poNumber;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The orderDate
     * @var string
     */
    public $orderDate;
    /**
     * The shipDate
     * @var string
     */
    public $shipDate;
    /**
     * Constructor method for OrderStatus
     * @uses OrderStatus::setCustomerNumber()
     * @uses OrderStatus::setPoNumber()
     * @uses OrderStatus::setOrderNumber()
     * @uses OrderStatus::setStatus()
     * @uses OrderStatus::setOrderDate()
     * @uses OrderStatus::setShipDate()
     * @param string $customerNumber
     * @param string $poNumber
     * @param string $orderNumber
     * @param string $status
     * @param string $orderDate
     * @param string $shipDate
     */
    public function __construct($customerNumber = null, $poNumber = null, $orderNumber = null, $status = null, $orderDate = null, $shipDate = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setPoNumber($poNumber)
            ->setOrderNumber($orderNumber)
            ->setStatus($status)
            ->setOrderDate($orderDate)
            ->setShipDate($shipDate);
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\OrderStatus
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get poNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
    /**
     * Set poNumber value
     * @param string $poNumber
     * @return \StructType\OrderStatus
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->poNumber = $poNumber;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderStatus
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\OrderStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\OrderStatus
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\OrderStatus
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
