<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The customerNumber
     * @var string
     */
    public $customerNumber;
    /**
     * The poNumber
     * @var string
     */
    public $poNumber;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * Constructor method for Order
     * @uses Order::setCustomerNumber()
     * @uses Order::setPoNumber()
     * @uses Order::setOrderNumber()
     * @param string $customerNumber
     * @param string $poNumber
     * @param string $orderNumber
     */
    public function __construct($customerNumber = null, $poNumber = null, $orderNumber = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setPoNumber($poNumber)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get customerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }
    /**
     * Set customerNumber value
     * @param string $customerNumber
     * @return \StructType\Order
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->customerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get poNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
    /**
     * Set poNumber value
     * @param string $poNumber
     * @return \StructType\Order
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->poNumber = $poNumber;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Order
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
