<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDetailsByReference StructType
 * @subpackage Structs
 */
class GetDetailsByReference extends AbstractStructBase
{
    /**
     * The total
     * @var string
     */
    public $total;
    /**
     * The referenceNumber
     * @var string
     */
    public $referenceNumber;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - arrayType: tns:ReferenceLine[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ReferenceLine[]
     */
    public $lines;
    /**
     * The taxAmount
     * @var string
     */
    public $taxAmount;
    /**
     * The discountAmount
     * @var string
     */
    public $discountAmount;
    /**
     * The dutyAmount
     * @var string
     */
    public $dutyAmount;
    /**
     * The freightAmount
     * @var string
     */
    public $freightAmount;
    /**
     * Constructor method for GetDetailsByReference
     * @uses GetDetailsByReference::setTotal()
     * @uses GetDetailsByReference::setReferenceNumber()
     * @uses GetDetailsByReference::setLines()
     * @uses GetDetailsByReference::setTaxAmount()
     * @uses GetDetailsByReference::setDiscountAmount()
     * @uses GetDetailsByReference::setDutyAmount()
     * @uses GetDetailsByReference::setFreightAmount()
     * @param string $total
     * @param string $referenceNumber
     * @param \StructType\ReferenceLine[] $lines
     * @param string $taxAmount
     * @param string $discountAmount
     * @param string $dutyAmount
     * @param string $freightAmount
     */
    public function __construct($total = null, $referenceNumber = null, array $lines = array(), $taxAmount = null, $discountAmount = null, $dutyAmount = null, $freightAmount = null)
    {
        $this
            ->setTotal($total)
            ->setReferenceNumber($referenceNumber)
            ->setLines($lines)
            ->setTaxAmount($taxAmount)
            ->setDiscountAmount($discountAmount)
            ->setDutyAmount($dutyAmount)
            ->setFreightAmount($freightAmount);
    }
    /**
     * Get total value
     * @return string|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param string $total
     * @return \StructType\GetDetailsByReference
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\GetDetailsByReference
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get lines value
     * @return \StructType\ReferenceLine[]|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * This method is responsible for validating the values passed to the setLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinesForArrayConstraintsFromSetLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getDetailsByReferenceLinesItem) {
            // validation for constraint: itemType
            if (!$getDetailsByReferenceLinesItem instanceof \StructType\ReferenceLine) {
                $invalidValues[] = is_object($getDetailsByReferenceLinesItem) ? get_class($getDetailsByReferenceLinesItem) : sprintf('%s(%s)', gettype($getDetailsByReferenceLinesItem), var_export($getDetailsByReferenceLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lines property can only contain items of type \StructType\ReferenceLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lines value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceLine[] $lines
     * @return \StructType\GetDetailsByReference
     */
    public function setLines(array $lines = array())
    {
        // validation for constraint: array
        if ('' !== ($linesArrayErrorMessage = self::validateLinesForArrayConstraintsFromSetLines($lines))) {
            throw new \InvalidArgumentException($linesArrayErrorMessage, __LINE__);
        }
        $this->lines = $lines;
        return $this;
    }
    /**
     * Add item to lines value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceLine $item
     * @return \StructType\GetDetailsByReference
     */
    public function addToLines(\StructType\ReferenceLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceLine) {
            throw new \InvalidArgumentException(sprintf('The lines property can only contain items of type \StructType\ReferenceLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lines[] = $item;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return string|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param string $taxAmount
     * @return \StructType\GetDetailsByReference
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: string
        if (!is_null($taxAmount) && !is_string($taxAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param string $discountAmount
     * @return \StructType\GetDetailsByReference
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: string
        if (!is_null($discountAmount) && !is_string($discountAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get dutyAmount value
     * @return string|null
     */
    public function getDutyAmount()
    {
        return $this->dutyAmount;
    }
    /**
     * Set dutyAmount value
     * @param string $dutyAmount
     * @return \StructType\GetDetailsByReference
     */
    public function setDutyAmount($dutyAmount = null)
    {
        // validation for constraint: string
        if (!is_null($dutyAmount) && !is_string($dutyAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dutyAmount, true), gettype($dutyAmount)), __LINE__);
        }
        $this->dutyAmount = $dutyAmount;
        return $this;
    }
    /**
     * Get freightAmount value
     * @return string|null
     */
    public function getFreightAmount()
    {
        return $this->freightAmount;
    }
    /**
     * Set freightAmount value
     * @param string $freightAmount
     * @return \StructType\GetDetailsByReference
     */
    public function setFreightAmount($freightAmount = null)
    {
        // validation for constraint: string
        if (!is_null($freightAmount) && !is_string($freightAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightAmount, true), gettype($freightAmount)), __LINE__);
        }
        $this->freightAmount = $freightAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDetailsByReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
