<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getStatusCodeList
     * Meta information extracted from the WSDL
     * - documentation: Returns list of possible order statuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\OrderStatusCode[]|bool
     */
    public function getStatusCodeList($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getStatusCodeList($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStatuses
     * Meta information extracted from the WSDL
     * - documentation: Gets the order statuses.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $orderNumber
     * @param string $poNumber
     * @param string $minDate
     * @param string $maxDate
     * @return \StructType\OrderStatus[]|bool
     */
    public function getStatuses($customerNumber, $userCredential, $orderNumber, $poNumber, $minDate, $maxDate)
    {
        try {
            $this->setResult($this->getSoapClient()->getStatuses($customerNumber, $userCredential, $orderNumber, $poNumber, $minDate, $maxDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConfirmations
     * Meta information extracted from the WSDL
     * - documentation: Gets the order confirmations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $date
     * @return \StructType\Order[]|bool
     */
    public function getConfirmations($customerNumber, $userCredential, $date)
    {
        try {
            $this->setResult($this->getSoapClient()->getConfirmations($customerNumber, $userCredential, $date));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrder
     * Meta information extracted from the WSDL
     * - documentation: Gets the order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $orderNumber
     * @return \StructType\Order|bool
     */
    public function getOrder($customerNumber, $userCredential, $orderNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrder($customerNumber, $userCredential, $orderNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderStatusGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $orderNumber
     * @param string $poNumber
     * @param string $minDate
     * @param string $maxDate
     * @return \StructType\OrderStatus[]|bool
     */
    public function getOrderStatusGroup($customerNumber, $userCredential, $orderNumber, $poNumber, $minDate, $maxDate)
    {
        try {
            $this->setResult($this->getSoapClient()->getOrderStatusGroup($customerNumber, $userCredential, $orderNumber, $poNumber, $minDate, $maxDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineItemsByReference
     * Meta information extracted from the WSDL
     * - documentation: This service is custom made for the BOA level 3 datahttps://support.payeezy.com/hc/en-us/articles/206601408-First-Data-Payeezy-Gateway-Web-Service-API-Reference-Guide#4.3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $isInvoice
     * @param string $referenceNumber
     * @return \StructType\GetDetailsByReference|bool
     */
    public function getLineItemsByReference($customerNumber, $userCredential, $isInvoice, $referenceNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getLineItemsByReference($customerNumber, $userCredential, $isInvoice, $referenceNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDetailsByReference|\StructType\Order|\StructType\OrderStatusCode[]|\StructType\OrderStatus[]|\StructType\Order[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
