<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductImageResult StructType
 * @subpackage Structs
 */
class ProductImageResult extends AbstractStructBase
{
    /**
     * The all
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var string[]
     */
    public $all;
    /**
     * The main
     * @var string
     */
    public $main;
    /**
     * Constructor method for ProductImageResult
     * @uses ProductImageResult::setAll()
     * @uses ProductImageResult::setMain()
     * @param string[] $all
     * @param string $main
     */
    public function __construct(array $all = array(), $main = null)
    {
        $this
            ->setAll($all)
            ->setMain($main);
    }
    /**
     * Get all value
     * @return string[]|null
     */
    public function getAll()
    {
        return $this->all;
    }
    /**
     * This method is responsible for validating the values passed to the setAll method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAll method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllForArrayConstraintsFromSetAll(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productImageResultAllItem) {
            // validation for constraint: itemType
            if (!is_string($productImageResultAllItem)) {
                $invalidValues[] = is_object($productImageResultAllItem) ? get_class($productImageResultAllItem) : sprintf('%s(%s)', gettype($productImageResultAllItem), var_export($productImageResultAllItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The all property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set all value
     * @throws \InvalidArgumentException
     * @param string[] $all
     * @return \StructType\ProductImageResult
     */
    public function setAll(array $all = array())
    {
        // validation for constraint: array
        if ('' !== ($allArrayErrorMessage = self::validateAllForArrayConstraintsFromSetAll($all))) {
            throw new \InvalidArgumentException($allArrayErrorMessage, __LINE__);
        }
        $this->all = $all;
        return $this;
    }
    /**
     * Add item to all value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductImageResult
     */
    public function addToAll($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The all property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->all[] = $item;
        return $this;
    }
    /**
     * Get main value
     * @return string|null
     */
    public function getMain()
    {
        return $this->main;
    }
    /**
     * Set main value
     * @param string $main
     * @return \StructType\ProductImageResult
     */
    public function setMain($main = null)
    {
        // validation for constraint: string
        if (!is_null($main) && !is_string($main)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($main, true), gettype($main)), __LINE__);
        }
        $this->main = $main;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductImageResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
