<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Decoration StructType
 * @subpackage Structs
 */
class Decoration extends AbstractStructBase
{
    /**
     * The decoration_code
     * @var string
     */
    public $decoration_code;
    /**
     * The decoration_name
     * @var string
     */
    public $decoration_name;
    /**
     * Constructor method for Decoration
     * @uses Decoration::setDecoration_code()
     * @uses Decoration::setDecoration_name()
     * @param string $decoration_code
     * @param string $decoration_name
     */
    public function __construct($decoration_code = null, $decoration_name = null)
    {
        $this
            ->setDecoration_code($decoration_code)
            ->setDecoration_name($decoration_name);
    }
    /**
     * Get decoration_code value
     * @return string|null
     */
    public function getDecoration_code()
    {
        return $this->decoration_code;
    }
    /**
     * Set decoration_code value
     * @param string $decoration_code
     * @return \StructType\Decoration
     */
    public function setDecoration_code($decoration_code = null)
    {
        // validation for constraint: string
        if (!is_null($decoration_code) && !is_string($decoration_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decoration_code, true), gettype($decoration_code)), __LINE__);
        }
        $this->decoration_code = $decoration_code;
        return $this;
    }
    /**
     * Get decoration_name value
     * @return string|null
     */
    public function getDecoration_name()
    {
        return $this->decoration_name;
    }
    /**
     * Set decoration_name value
     * @param string $decoration_name
     * @return \StructType\Decoration
     */
    public function setDecoration_name($decoration_name = null)
    {
        // validation for constraint: string
        if (!is_null($decoration_name) && !is_string($decoration_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decoration_name, true), gettype($decoration_name)), __LINE__);
        }
        $this->decoration_name = $decoration_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Decoration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
