<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CMProductDataResult StructType
 * @subpackage Structs
 */
class CMProductDataResult extends AbstractStructBase
{
    /**
     * The product
     * @var Array
     */
    public $product;
    /**
     * The imprint
     * @var mixed
     */
    public $imprint;
    /**
     * The setUpCharge
     * @var Array
     */
    public $setUpCharge;
    /**
     * The itemMaterial
     * @var string
     */
    public $itemMaterial;
    /**
     * The itemDimensions
     * @var string
     */
    public $itemDimensions;
    /**
     * The itemColors
     * @var Array
     */
    public $itemColors;
    /**
     * The countryOfOrigin
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The shipFromZip
     * @var string
     */
    public $shipFromZip;
    /**
     * The isHazMat
     * @var bool
     */
    public $isHazMat;
    /**
     * The quantityOnHand
     * @var Array
     */
    public $quantityOnHand;
    /**
     * The discontinued
     * @var bool
     */
    public $discontinued;
    /**
     * The lastModified
     * @var string
     */
    public $lastModified;
    /**
     * The expeditedServicesOffered
     * @var string
     */
    public $expeditedServicesOffered;
    /**
     * The images
     * @var Array
     */
    public $images;
    /**
     * The itemWeight
     * @var Array
     */
    public $itemWeight;
    /**
     * The package
     * @var Array
     */
    public $package;
    /**
     * The pricing
     * @var mixed
     */
    public $pricing;
    /**
     * Constructor method for CMProductDataResult
     * @uses CMProductDataResult::setProduct()
     * @uses CMProductDataResult::setImprint()
     * @uses CMProductDataResult::setSetUpCharge()
     * @uses CMProductDataResult::setItemMaterial()
     * @uses CMProductDataResult::setItemDimensions()
     * @uses CMProductDataResult::setItemColors()
     * @uses CMProductDataResult::setCountryOfOrigin()
     * @uses CMProductDataResult::setShipFromZip()
     * @uses CMProductDataResult::setIsHazMat()
     * @uses CMProductDataResult::setQuantityOnHand()
     * @uses CMProductDataResult::setDiscontinued()
     * @uses CMProductDataResult::setLastModified()
     * @uses CMProductDataResult::setExpeditedServicesOffered()
     * @uses CMProductDataResult::setImages()
     * @uses CMProductDataResult::setItemWeight()
     * @uses CMProductDataResult::setPackage()
     * @uses CMProductDataResult::setPricing()
     * @param Array $product
     * @param mixed $imprint
     * @param Array $setUpCharge
     * @param string $itemMaterial
     * @param string $itemDimensions
     * @param Array $itemColors
     * @param string $countryOfOrigin
     * @param string $shipFromZip
     * @param bool $isHazMat
     * @param Array $quantityOnHand
     * @param bool $discontinued
     * @param string $lastModified
     * @param string $expeditedServicesOffered
     * @param Array $images
     * @param Array $itemWeight
     * @param Array $package
     * @param mixed $pricing
     */
    public function __construct(Array $product = null, $imprint = null, Array $setUpCharge = null, $itemMaterial = null, $itemDimensions = null, Array $itemColors = null, $countryOfOrigin = null, $shipFromZip = null, $isHazMat = null, Array $quantityOnHand = null, $discontinued = null, $lastModified = null, $expeditedServicesOffered = null, Array $images = null, Array $itemWeight = null, Array $package = null, $pricing = null)
    {
        $this
            ->setProduct($product)
            ->setImprint($imprint)
            ->setSetUpCharge($setUpCharge)
            ->setItemMaterial($itemMaterial)
            ->setItemDimensions($itemDimensions)
            ->setItemColors($itemColors)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setShipFromZip($shipFromZip)
            ->setIsHazMat($isHazMat)
            ->setQuantityOnHand($quantityOnHand)
            ->setDiscontinued($discontinued)
            ->setLastModified($lastModified)
            ->setExpeditedServicesOffered($expeditedServicesOffered)
            ->setImages($images)
            ->setItemWeight($itemWeight)
            ->setPackage($package)
            ->setPricing($pricing);
    }
    /**
     * Get product value
     * @return Array|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param Array $product
     * @return \StructType\CMProductDataResult
     */
    public function setProduct(Array $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get imprint value
     * @return mixed|null
     */
    public function getImprint()
    {
        return $this->imprint;
    }
    /**
     * Set imprint value
     * @param mixed $imprint
     * @return \StructType\CMProductDataResult
     */
    public function setImprint($imprint = null)
    {
        $this->imprint = $imprint;
        return $this;
    }
    /**
     * Get setUpCharge value
     * @return Array|null
     */
    public function getSetUpCharge()
    {
        return $this->setUpCharge;
    }
    /**
     * Set setUpCharge value
     * @param Array $setUpCharge
     * @return \StructType\CMProductDataResult
     */
    public function setSetUpCharge(Array $setUpCharge = null)
    {
        $this->setUpCharge = $setUpCharge;
        return $this;
    }
    /**
     * Get itemMaterial value
     * @return string|null
     */
    public function getItemMaterial()
    {
        return $this->itemMaterial;
    }
    /**
     * Set itemMaterial value
     * @param string $itemMaterial
     * @return \StructType\CMProductDataResult
     */
    public function setItemMaterial($itemMaterial = null)
    {
        // validation for constraint: string
        if (!is_null($itemMaterial) && !is_string($itemMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemMaterial, true), gettype($itemMaterial)), __LINE__);
        }
        $this->itemMaterial = $itemMaterial;
        return $this;
    }
    /**
     * Get itemDimensions value
     * @return string|null
     */
    public function getItemDimensions()
    {
        return $this->itemDimensions;
    }
    /**
     * Set itemDimensions value
     * @param string $itemDimensions
     * @return \StructType\CMProductDataResult
     */
    public function setItemDimensions($itemDimensions = null)
    {
        // validation for constraint: string
        if (!is_null($itemDimensions) && !is_string($itemDimensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDimensions, true), gettype($itemDimensions)), __LINE__);
        }
        $this->itemDimensions = $itemDimensions;
        return $this;
    }
    /**
     * Get itemColors value
     * @return Array|null
     */
    public function getItemColors()
    {
        return $this->itemColors;
    }
    /**
     * Set itemColors value
     * @param Array $itemColors
     * @return \StructType\CMProductDataResult
     */
    public function setItemColors(Array $itemColors = null)
    {
        $this->itemColors = $itemColors;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \StructType\CMProductDataResult
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get shipFromZip value
     * @return string|null
     */
    public function getShipFromZip()
    {
        return $this->shipFromZip;
    }
    /**
     * Set shipFromZip value
     * @param string $shipFromZip
     * @return \StructType\CMProductDataResult
     */
    public function setShipFromZip($shipFromZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipFromZip) && !is_string($shipFromZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipFromZip, true), gettype($shipFromZip)), __LINE__);
        }
        $this->shipFromZip = $shipFromZip;
        return $this;
    }
    /**
     * Get isHazMat value
     * @return bool|null
     */
    public function getIsHazMat()
    {
        return $this->isHazMat;
    }
    /**
     * Set isHazMat value
     * @param bool $isHazMat
     * @return \StructType\CMProductDataResult
     */
    public function setIsHazMat($isHazMat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHazMat) && !is_bool($isHazMat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHazMat, true), gettype($isHazMat)), __LINE__);
        }
        $this->isHazMat = $isHazMat;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return Array|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param Array $quantityOnHand
     * @return \StructType\CMProductDataResult
     */
    public function setQuantityOnHand(Array $quantityOnHand = null)
    {
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get discontinued value
     * @return bool|null
     */
    public function getDiscontinued()
    {
        return $this->discontinued;
    }
    /**
     * Set discontinued value
     * @param bool $discontinued
     * @return \StructType\CMProductDataResult
     */
    public function setDiscontinued($discontinued = null)
    {
        // validation for constraint: boolean
        if (!is_null($discontinued) && !is_bool($discontinued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discontinued, true), gettype($discontinued)), __LINE__);
        }
        $this->discontinued = $discontinued;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\CMProductDataResult
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get expeditedServicesOffered value
     * @return string|null
     */
    public function getExpeditedServicesOffered()
    {
        return $this->expeditedServicesOffered;
    }
    /**
     * Set expeditedServicesOffered value
     * @param string $expeditedServicesOffered
     * @return \StructType\CMProductDataResult
     */
    public function setExpeditedServicesOffered($expeditedServicesOffered = null)
    {
        // validation for constraint: string
        if (!is_null($expeditedServicesOffered) && !is_string($expeditedServicesOffered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expeditedServicesOffered, true), gettype($expeditedServicesOffered)), __LINE__);
        }
        $this->expeditedServicesOffered = $expeditedServicesOffered;
        return $this;
    }
    /**
     * Get images value
     * @return Array|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param Array $images
     * @return \StructType\CMProductDataResult
     */
    public function setImages(Array $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get itemWeight value
     * @return Array|null
     */
    public function getItemWeight()
    {
        return $this->itemWeight;
    }
    /**
     * Set itemWeight value
     * @param Array $itemWeight
     * @return \StructType\CMProductDataResult
     */
    public function setItemWeight(Array $itemWeight = null)
    {
        $this->itemWeight = $itemWeight;
        return $this;
    }
    /**
     * Get package value
     * @return Array|null
     */
    public function getPackage()
    {
        return $this->package;
    }
    /**
     * Set package value
     * @param Array $package
     * @return \StructType\CMProductDataResult
     */
    public function setPackage(Array $package = null)
    {
        $this->package = $package;
        return $this;
    }
    /**
     * Get pricing value
     * @return mixed|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param mixed $pricing
     * @return \StructType\CMProductDataResult
     */
    public function setPricing($pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CMProductDataResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
