<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subcategory StructType
 * @subpackage Structs
 */
class Subcategory extends AbstractStructBase
{
    /**
     * The products
     * Meta information extracted from the WSDL
     * - arrayType: tns:ProductId[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\ProductId[]
     */
    public $products;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for Subcategory
     * @uses Subcategory::setProducts()
     * @uses Subcategory::setId()
     * @uses Subcategory::setName()
     * @param \StructType\ProductId[] $products
     * @param string $id
     * @param string $name
     */
    public function __construct(array $products = array(), $id = null, $name = null)
    {
        $this
            ->setProducts($products)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get products value
     * @return \StructType\ProductId[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * This method is responsible for validating the values passed to the setProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductsForArrayConstraintsFromSetProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subcategoryProductsItem) {
            // validation for constraint: itemType
            if (!$subcategoryProductsItem instanceof \StructType\ProductId) {
                $invalidValues[] = is_object($subcategoryProductsItem) ? get_class($subcategoryProductsItem) : sprintf('%s(%s)', gettype($subcategoryProductsItem), var_export($subcategoryProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The products property can only contain items of type \StructType\ProductId, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductId[] $products
     * @return \StructType\Subcategory
     */
    public function setProducts(array $products = array())
    {
        // validation for constraint: array
        if ('' !== ($productsArrayErrorMessage = self::validateProductsForArrayConstraintsFromSetProducts($products))) {
            throw new \InvalidArgumentException($productsArrayErrorMessage, __LINE__);
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductId $item
     * @return \StructType\Subcategory
     */
    public function addToProducts(\StructType\ProductId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductId) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of type \StructType\ProductId, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Subcategory
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Subcategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subcategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
