<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawProductPackingSoap StructType
 * @subpackage Structs
 */
class RawProductPackingSoap extends AbstractStructBase
{
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The quantityPerBox
     * @var string
     */
    public $quantityPerBox;
    /**
     * The weight
     * @var string
     */
    public $weight;
    /**
     * The boxLength
     * @var string
     */
    public $boxLength;
    /**
     * The boxWidth
     * @var string
     */
    public $boxWidth;
    /**
     * The boxHeight
     * @var string
     */
    public $boxHeight;
    /**
     * Constructor method for RawProductPackingSoap
     * @uses RawProductPackingSoap::setProductNumber()
     * @uses RawProductPackingSoap::setQuantityPerBox()
     * @uses RawProductPackingSoap::setWeight()
     * @uses RawProductPackingSoap::setBoxLength()
     * @uses RawProductPackingSoap::setBoxWidth()
     * @uses RawProductPackingSoap::setBoxHeight()
     * @param string $productNumber
     * @param string $quantityPerBox
     * @param string $weight
     * @param string $boxLength
     * @param string $boxWidth
     * @param string $boxHeight
     */
    public function __construct($productNumber = null, $quantityPerBox = null, $weight = null, $boxLength = null, $boxWidth = null, $boxHeight = null)
    {
        $this
            ->setProductNumber($productNumber)
            ->setQuantityPerBox($quantityPerBox)
            ->setWeight($weight)
            ->setBoxLength($boxLength)
            ->setBoxWidth($boxWidth)
            ->setBoxHeight($boxHeight);
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\RawProductPackingSoap
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get quantityPerBox value
     * @return string|null
     */
    public function getQuantityPerBox()
    {
        return $this->quantityPerBox;
    }
    /**
     * Set quantityPerBox value
     * @param string $quantityPerBox
     * @return \StructType\RawProductPackingSoap
     */
    public function setQuantityPerBox($quantityPerBox = null)
    {
        // validation for constraint: string
        if (!is_null($quantityPerBox) && !is_string($quantityPerBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityPerBox, true), gettype($quantityPerBox)), __LINE__);
        }
        $this->quantityPerBox = $quantityPerBox;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \StructType\RawProductPackingSoap
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get boxLength value
     * @return string|null
     */
    public function getBoxLength()
    {
        return $this->boxLength;
    }
    /**
     * Set boxLength value
     * @param string $boxLength
     * @return \StructType\RawProductPackingSoap
     */
    public function setBoxLength($boxLength = null)
    {
        // validation for constraint: string
        if (!is_null($boxLength) && !is_string($boxLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxLength, true), gettype($boxLength)), __LINE__);
        }
        $this->boxLength = $boxLength;
        return $this;
    }
    /**
     * Get boxWidth value
     * @return string|null
     */
    public function getBoxWidth()
    {
        return $this->boxWidth;
    }
    /**
     * Set boxWidth value
     * @param string $boxWidth
     * @return \StructType\RawProductPackingSoap
     */
    public function setBoxWidth($boxWidth = null)
    {
        // validation for constraint: string
        if (!is_null($boxWidth) && !is_string($boxWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxWidth, true), gettype($boxWidth)), __LINE__);
        }
        $this->boxWidth = $boxWidth;
        return $this;
    }
    /**
     * Get boxHeight value
     * @return string|null
     */
    public function getBoxHeight()
    {
        return $this->boxHeight;
    }
    /**
     * Set boxHeight value
     * @param string $boxHeight
     * @return \StructType\RawProductPackingSoap
     */
    public function setBoxHeight($boxHeight = null)
    {
        // validation for constraint: string
        if (!is_null($boxHeight) && !is_string($boxHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxHeight, true), gettype($boxHeight)), __LINE__);
        }
        $this->boxHeight = $boxHeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RawProductPackingSoap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
