<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSetupData StructType
 * @subpackage Structs
 */
class ProductSetupData extends AbstractStructBase
{
    /**
     * The decoration_code
     * @var string
     */
    public $decoration_code;
    /**
     * The decoration
     * @var string
     */
    public $decoration;
    /**
     * The setup_charge
     * @var string
     */
    public $setup_charge;
    /**
     * The run_charge
     * @var string
     */
    public $run_charge;
    /**
     * The extra_color_charge
     * @var string
     */
    public $extra_color_charge;
    /**
     * The extra_location_charge
     * @var string
     */
    public $extra_location_charge;
    /**
     * Constructor method for ProductSetupData
     * @uses ProductSetupData::setDecoration_code()
     * @uses ProductSetupData::setDecoration()
     * @uses ProductSetupData::setSetup_charge()
     * @uses ProductSetupData::setRun_charge()
     * @uses ProductSetupData::setExtra_color_charge()
     * @uses ProductSetupData::setExtra_location_charge()
     * @param string $decoration_code
     * @param string $decoration
     * @param string $setup_charge
     * @param string $run_charge
     * @param string $extra_color_charge
     * @param string $extra_location_charge
     */
    public function __construct($decoration_code = null, $decoration = null, $setup_charge = null, $run_charge = null, $extra_color_charge = null, $extra_location_charge = null)
    {
        $this
            ->setDecoration_code($decoration_code)
            ->setDecoration($decoration)
            ->setSetup_charge($setup_charge)
            ->setRun_charge($run_charge)
            ->setExtra_color_charge($extra_color_charge)
            ->setExtra_location_charge($extra_location_charge);
    }
    /**
     * Get decoration_code value
     * @return string|null
     */
    public function getDecoration_code()
    {
        return $this->decoration_code;
    }
    /**
     * Set decoration_code value
     * @param string $decoration_code
     * @return \StructType\ProductSetupData
     */
    public function setDecoration_code($decoration_code = null)
    {
        // validation for constraint: string
        if (!is_null($decoration_code) && !is_string($decoration_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decoration_code, true), gettype($decoration_code)), __LINE__);
        }
        $this->decoration_code = $decoration_code;
        return $this;
    }
    /**
     * Get decoration value
     * @return string|null
     */
    public function getDecoration()
    {
        return $this->decoration;
    }
    /**
     * Set decoration value
     * @param string $decoration
     * @return \StructType\ProductSetupData
     */
    public function setDecoration($decoration = null)
    {
        // validation for constraint: string
        if (!is_null($decoration) && !is_string($decoration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decoration, true), gettype($decoration)), __LINE__);
        }
        $this->decoration = $decoration;
        return $this;
    }
    /**
     * Get setup_charge value
     * @return string|null
     */
    public function getSetup_charge()
    {
        return $this->setup_charge;
    }
    /**
     * Set setup_charge value
     * @param string $setup_charge
     * @return \StructType\ProductSetupData
     */
    public function setSetup_charge($setup_charge = null)
    {
        // validation for constraint: string
        if (!is_null($setup_charge) && !is_string($setup_charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($setup_charge, true), gettype($setup_charge)), __LINE__);
        }
        $this->setup_charge = $setup_charge;
        return $this;
    }
    /**
     * Get run_charge value
     * @return string|null
     */
    public function getRun_charge()
    {
        return $this->run_charge;
    }
    /**
     * Set run_charge value
     * @param string $run_charge
     * @return \StructType\ProductSetupData
     */
    public function setRun_charge($run_charge = null)
    {
        // validation for constraint: string
        if (!is_null($run_charge) && !is_string($run_charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($run_charge, true), gettype($run_charge)), __LINE__);
        }
        $this->run_charge = $run_charge;
        return $this;
    }
    /**
     * Get extra_color_charge value
     * @return string|null
     */
    public function getExtra_color_charge()
    {
        return $this->extra_color_charge;
    }
    /**
     * Set extra_color_charge value
     * @param string $extra_color_charge
     * @return \StructType\ProductSetupData
     */
    public function setExtra_color_charge($extra_color_charge = null)
    {
        // validation for constraint: string
        if (!is_null($extra_color_charge) && !is_string($extra_color_charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extra_color_charge, true), gettype($extra_color_charge)), __LINE__);
        }
        $this->extra_color_charge = $extra_color_charge;
        return $this;
    }
    /**
     * Get extra_location_charge value
     * @return string|null
     */
    public function getExtra_location_charge()
    {
        return $this->extra_location_charge;
    }
    /**
     * Set extra_location_charge value
     * @param string $extra_location_charge
     * @return \StructType\ProductSetupData
     */
    public function setExtra_location_charge($extra_location_charge = null)
    {
        // validation for constraint: string
        if (!is_null($extra_location_charge) && !is_string($extra_location_charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extra_location_charge, true), gettype($extra_location_charge)), __LINE__);
        }
        $this->extra_location_charge = $extra_location_charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSetupData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
